/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.ai.attack;

import com.hungteen.pvz.utils.EntityUtil;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;

public abstract class PVZMeleeAttackGoal
extends Goal {
    protected final CreatureEntity attacker;
    protected int attackTick;
    protected final double speedTowardsTarget;
    protected final boolean longMemory;
    protected Path path;
    private int delayCnt = 1;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private long lastExcuteTime = 0L;
    private int failedPathFindingPenalty = 0;
    protected boolean canPenalize = false;

    public PVZMeleeAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
        this.attacker = creature;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        long currentTime = this.attacker.field_70170_p.func_82737_E();
        if (currentTime - this.lastExcuteTime < 20L) {
            return false;
        }
        this.lastExcuteTime = currentTime;
        LivingEntity living = this.attacker.func_70638_az();
        if (!EntityUtil.isEntityValid((Entity)living)) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)living, 0);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)living, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(living) >= EntityUtil.getNearestDistance((Entity)this.attacker, (Entity)living);
    }

    public boolean func_75253_b() {
        LivingEntity living = this.attacker.func_70638_az();
        if (!EntityUtil.isEntityValid((Entity)living)) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_213389_a(new BlockPos(living.func_213303_ch()))) {
            return false;
        }
        return EntityUtil.checkCanEntityTarget((Entity)this.attacker, living);
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        this.attacker.func_70624_b(null);
        this.attacker.func_213395_q(false);
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity target = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)target)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = target.func_226277_ct_();
            this.targetY = target.func_226278_cu_();
            this.targetZ = target.func_226281_cx_();
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && target.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)target, this.speedTowardsTarget)) {
                this.delayCounter += 15 * this.delayCnt;
                this.delayCnt = Math.min(10, this.delayCnt + 1);
            } else {
                this.delayCnt = Math.max(1, this.delayCnt - 1);
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(target);
    }

    protected abstract void checkAndPerformAttack(LivingEntity var1);

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return EntityUtil.getAttackRange((Entity)this.attacker, (Entity)attackTarget, 0.5);
    }
}

