/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.ai.target;

import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.util.math.AxisAlignedBB;

public class PVZNearestTargetGoal
extends TargetGoal {
    protected final AlgorithmUtil.EntitySorter sorter;
    private final int targetChance;
    private final float upperHeight;
    private final float lowerHeight;
    private final float width;

    public PVZNearestTargetGoal(MobEntity mobIn, boolean checkSight, float w, float h) {
        this(mobIn, checkSight, 5, w, h);
    }

    public PVZNearestTargetGoal(MobEntity mobIn, boolean checkSight, int chance, float w, float h) {
        this(mobIn, checkSight, chance, w, h, h);
    }

    public PVZNearestTargetGoal(MobEntity mobIn, boolean checkSight, int chance, float w, float h1, float h2) {
        super(mobIn, checkSight);
        this.targetChance = chance;
        this.width = w;
        this.upperHeight = h1;
        this.lowerHeight = h2;
        this.sorter = new AlgorithmUtil.EntitySorter((Entity)this.field_75299_d);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        ArrayList<LivingEntity> list1 = new ArrayList<LivingEntity>();
        for (LivingEntity entity : EntityUtil.getEntityTargetableEntity((Entity)this.field_75299_d, this.getAABB())) {
            if (entity == this.field_75299_d || this.field_75297_f && !this.checkSenses((Entity)entity) || !this.checkOther(entity)) continue;
            list1.add(entity);
        }
        if (list1.isEmpty()) {
            return false;
        }
        Collections.sort(list1, this.sorter);
        this.field_188509_g = (LivingEntity)list1.get(0);
        return true;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.field_188509_g);
    }

    public boolean func_75253_b() {
        LivingEntity entity = this.field_75299_d.func_70638_az();
        if (entity == null) {
            entity = this.field_188509_g;
        }
        if (entity == null || !entity.func_70089_S()) {
            return false;
        }
        if (EntityUtil.checkCanEntityTarget((Entity)this.field_75299_d, entity) && entity != this.field_75299_d && (!this.field_75297_f || this.checkSenses((Entity)entity)) && this.checkOther(entity)) {
            this.field_75299_d.func_70624_b(entity);
            return true;
        }
        return false;
    }

    protected boolean checkSenses(Entity entity) {
        return this.field_75299_d.func_70635_at().func_75522_a(entity);
    }

    protected boolean checkOther(LivingEntity entity) {
        return true;
    }

    private AxisAlignedBB getAABB() {
        return new AxisAlignedBB(this.field_75299_d.func_226277_ct_() + (double)this.width, this.field_75299_d.func_226278_cu_() + (double)this.upperHeight, this.field_75299_d.func_226281_cx_() + (double)this.width, this.field_75299_d.func_226277_ct_() - (double)this.width, this.field_75299_d.func_226278_cu_() - (double)this.lowerHeight, this.field_75299_d.func_226281_cx_() - (double)this.width);
    }
}

