/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet;

import com.hungteen.pvz.entity.bullet.itembullet.PVZItemBulletEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.entity.plant.toxic.GloomShroomEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.ParticleRegister;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class FumeEntity
extends PVZItemBulletEntity {
    private int knockback = 0;

    public FumeEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public FumeEntity(World worldIn, LivingEntity living) {
        super((EntityType)EntityRegister.FUME.get(), worldIn, living);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            int cnt = this.field_70173_aa < this.getMaxLiveTick() / 2 ? 6 : 4;
            for (int i = 0; i < cnt; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.FUME.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected int getMaxLiveTick() {
        if (this.getThrower() instanceof GloomShroomEntity) {
            return 5;
        }
        return 25;
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegister.SPORE.get());
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        Entity target;
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.checkCanAttack(target = ((EntityRayTraceResult)result).func_216348_a())) {
            target.field_70172_ad = 0;
            this.dealFumeDamage(target);
            if (this.hitEntities == null) {
                this.hitEntities = new IntOpenHashSet();
            }
            this.addHitEntity(target);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag || !this.checkLive(result)) {
            this.func_70106_y();
        }
    }

    @Override
    protected boolean checkLive(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Block block = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a()).func_177230_c();
            return block instanceof BushBlock;
        }
        return true;
    }

    private void dealFumeDamage(Entity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.causeThroughDamage(this, (Entity)this.getThrower()), this.attackDamage);
        if (!this.field_70170_p.field_72995_K && this.knockback > 0) {
            Vector3d speed = target.func_213322_ci();
            Vector3d now = this.func_213322_ci();
            int lvl = this.knockback;
            target.func_213317_d(speed.func_178787_e(now).func_216372_d((double)lvl, (double)lvl, (double)lvl));
        }
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof PlantShooterEntity) {
            return ((PlantShooterEntity)this.getThrower()).getAttackDamage();
        }
        return 0.0f;
    }

    public void setKnockback(int lvl) {
        this.knockback = lvl;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
    }

    @Override
    protected float getGravityVelocity() {
        return 0.002f;
    }
}

