/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet;

import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.arma.MelonPultEntity;
import com.hungteen.pvz.entity.plant.ice.WinterMelonEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class MelonEntity
extends PultBulletEntity {
    private static final DataParameter<Integer> MELON_TYPE = EntityDataManager.func_187226_a(MelonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MELON_STATE = EntityDataManager.func_187226_a(MelonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Entity attackEntity = null;
    protected float splashDamage = 0.0f;

    public MelonEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public MelonEntity(World worldIn, LivingEntity shooter) {
        super((EntityType)EntityRegister.MELON.get(), worldIn, shooter);
        this.splashDamage = this.getSplashDamage();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MELON_STATE, (Object)MelonStates.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(MELON_TYPE, (Object)MelonTypes.NORMAL.ordinal());
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.getIcePotion().isPresent()) {
            PVZDamageSource source = PVZDamageSource.causeIceDamage(this, (Entity)this.getThrower());
            source.addEffect(this.getIcePotion().get());
            target.func_70097_a((DamageSource)source, this.getFixDamage());
        } else {
            target.func_70097_a((DamageSource)PVZDamageSource.causeThrowDamage(this, (Entity)this.getThrower()), this.getFixDamage());
        }
        this.attackEntity = target;
        this.dealSplashDamage();
    }

    @Override
    protected void onHitBlock() {
        this.dealSplashDamage();
    }

    private void dealSplashDamage() {
        EntityUtil.playSound(this, (SoundEvent)SoundRegister.MELON_HIT.get());
        float range = 2.5f;
        EntityUtil.getAttackEntities((Entity)this.getThrower(), EntityUtil.getEntityAABB(this, range, range)).forEach(entity -> {
            if (!(entity.func_70028_i(this.attackEntity) || entity instanceof LivingEntity && !EntityUtil.checkCanEntityTarget((Entity)this.getThrower(), (LivingEntity)entity))) {
                PVZDamageSource source = PVZDamageSource.causeNormalDamage(this, (Entity)this.getThrower());
                this.getIcePotion().ifPresent(effect -> source.addEffect((EffectInstance)effect));
                entity.func_70097_a((DamageSource)source, this.splashDamage);
            }
        });
        for (int i = 0; i < 10; ++i) {
            EntityUtil.spawnParticle(this, this.getMelonState() == MelonStates.ICE ? 2 : 1);
        }
    }

    private Optional<EffectInstance> getIcePotion() {
        if (!(this.getThrower() instanceof WinterMelonEntity)) {
            return Optional.empty();
        }
        return Optional.of(((WinterMelonEntity)this.getThrower()).getColdEffect());
    }

    private float getFixDamage() {
        float damage = this.attackDamage;
        if (this.getMelonType() == MelonTypes.POWER) {
            damage += 12.0f;
        }
        return damage;
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof MelonPultEntity) {
            return ((MelonPultEntity)this.getThrower()).getAttackDamage();
        }
        return 0.0f;
    }

    private float getSplashDamage() {
        if (this.getMelonType() == MelonTypes.POWER) {
            return 3.0f;
        }
        if (this.getThrower() instanceof MelonPultEntity) {
            return ((MelonPultEntity)this.getThrower()).getSplashDamage();
        }
        return 0.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)0.6f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("melon_type")) {
            this.setMelonType(MelonTypes.values()[compound.func_74762_e("melon_type")]);
        }
        if (compound.func_74764_b("melon_state")) {
            this.setMelonState(MelonStates.values()[compound.func_74762_e("melon_state")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("melon_type", this.getMelonType().ordinal());
        compound.func_74768_a("melon_state", this.getMelonState().ordinal());
    }

    public void setMelonType(MelonTypes type) {
        this.field_70180_af.func_187227_b(MELON_TYPE, (Object)type.ordinal());
    }

    public MelonTypes getMelonType() {
        return MelonTypes.values()[(Integer)this.field_70180_af.func_187225_a(MELON_TYPE)];
    }

    public void setMelonState(MelonStates type) {
        this.field_70180_af.func_187227_b(MELON_STATE, (Object)type.ordinal());
    }

    public MelonStates getMelonState() {
        return MelonStates.values()[(Integer)this.field_70180_af.func_187225_a(MELON_STATE)];
    }

    public static enum MelonTypes {
        NORMAL,
        POWER;

    }

    public static enum MelonStates {
        NORMAL,
        ICE;

    }
}

