/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet;

import com.hungteen.pvz.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class PultBulletEntity
extends AbstractBulletEntity {
    protected int targetChance = 5;
    protected Optional<LivingEntity> lockTarget = Optional.empty();
    protected Optional<BlockPos> lockPos = Optional.empty();
    protected float height = 12.0f;
    protected boolean isPushBack = false;

    public PultBulletEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.airSlowDown = 1.0f;
    }

    public PultBulletEntity(EntityType<?> type, World worldIn, LivingEntity shooter) {
        super(type, worldIn, shooter);
        this.airSlowDown = 1.0f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.isPushBack && this.field_70173_aa % this.targetChance == 0 && this.lockTarget.isPresent() && EntityUtil.isEntityValid((Entity)this.lockTarget.get())) {
            LivingEntity target = this.lockTarget.get();
            Vector3d speed = this.func_213322_ci();
            double g = this.getGravityVelocity();
            double t1 = speed.field_72448_b / g;
            double height = speed.field_72448_b * speed.field_72448_b / 2.0 / g;
            double downHeight = this.func_226278_cu_() + height - target.func_226278_cu_() - (double)target.func_213302_cg();
            if (downHeight < 0.0) {
                return;
            }
            double t2 = Math.sqrt(2.0 * downHeight / g);
            double dx = target.func_226277_ct_() + target.func_213322_ci().func_82615_a() * (t1 + t2) - this.func_226277_ct_();
            double dz = target.func_226281_cx_() + target.func_213322_ci().func_82616_c() * (t1 + t2) - this.func_226281_cx_();
            double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            double vxz = dxz / (t1 + t2);
            if (dxz == 0.0) {
                this.func_213293_j(0.0, speed.field_72448_b, 0.0);
            } else {
                this.func_213293_j(vxz * dx / dxz, speed.field_72448_b, vxz * dz / dxz);
            }
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        Entity target;
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.checkCanAttack(target = ((EntityRayTraceResult)result).func_216348_a())) {
            target.field_70172_ad = 0;
            this.dealDamage(target);
            flag = true;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag) {
            this.func_70106_y();
        } else if (!this.checkLive(result)) {
            this.onHitBlock();
            this.func_70106_y();
        }
    }

    protected void onHitBlock() {
    }

    @Override
    protected int getMaxLiveTick() {
        return 200;
    }

    public void pushBack() {
        this.isPushBack = true;
        this.func_213293_j((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f, this.field_70146_Z.nextFloat() * 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
    }

    protected abstract void dealDamage(Entity var1);

    public void shootPultBullet(LivingEntity target) {
        if (target == null) {
            System.out.println("Warn: No target at all .");
            return;
        }
        this.lockTarget = Optional.ofNullable(target);
        double g = this.getGravityVelocity();
        double t1 = MathHelper.func_76133_a((double)((double)(2.0f * this.height) / g));
        double t2 = 0.0;
        if (this.func_226278_cu_() + (double)this.height - target.func_226278_cu_() - (double)target.func_213302_cg() >= 0.0) {
            t2 = MathHelper.func_76133_a((double)(2.0 * (this.func_226278_cu_() + (double)this.height - target.func_226278_cu_() - (double)target.func_213302_cg()) / g));
        }
        double dx = target.func_226277_ct_() + target.func_213322_ci().func_82615_a() * (t1 + t2) - this.func_226277_ct_();
        double dz = target.func_226281_cx_() + target.func_213322_ci().func_82616_c() * (t1 + t2) - this.func_226281_cx_();
        double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double vxz = dxz / (t1 + t2);
        double vy = g * t1;
        if (dxz == 0.0) {
            this.func_213293_j(0.0, vy, 0.0);
        } else {
            this.func_213293_j(vxz * dx / dxz, vy, vxz * dz / dxz);
        }
    }

    public void shootPultBullet(BlockPos pos) {
        if (pos == null) {
            System.out.println("Warn: No pos at all .");
            return;
        }
        this.lockPos = Optional.ofNullable(pos);
        double g = this.getGravityVelocity();
        double t1 = MathHelper.func_76133_a((double)((double)(2.0f * this.height) / g));
        double t2 = 0.0;
        if (this.func_226278_cu_() + (double)this.height - (double)pos.func_177956_o() - 1.0 >= 0.0) {
            t2 = MathHelper.func_76133_a((double)(2.0 * (this.func_226278_cu_() + (double)this.height - (double)pos.func_177956_o() - 1.0) / g));
        }
        double dx = (double)pos.func_177958_n() - this.func_226277_ct_();
        double dz = (double)pos.func_177952_p() - this.func_226281_cx_();
        double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double vxz = dxz / (t1 + t2);
        double vy = g * t1;
        if (dxz == 0.0) {
            this.func_213293_j(0.0, vy, 0.0);
        } else {
            this.func_213293_j(vxz * dx / dxz, vy, vxz * dz / dxz);
        }
    }

    @Override
    protected float getGravityVelocity() {
        return 0.1f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("target_entity_id")) {
            this.lockTarget = Optional.ofNullable((LivingEntity)this.field_70170_p.func_73045_a(compound.func_74762_e("target_entity_id")));
        }
        if (compound.func_74764_b("is_target_push_back")) {
            this.isPushBack = compound.func_74767_n("is_target_push_back");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.lockTarget.isPresent()) {
            compound.func_74768_a("target_entity_id", this.lockTarget.get().func_145782_y());
        }
        compound.func_74757_a("is_target_push_back", this.isPushBack);
    }
}

