/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet.itembullet;

import com.hungteen.pvz.entity.bullet.itembullet.PVZItemBulletEntity;
import com.hungteen.pvz.entity.plant.assist.MagnetShroomEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MetalItemEntity
extends PVZItemBulletEntity {
    private static final DataParameter<Integer> METAL_TYPE = EntityDataManager.func_187226_a(MetalItemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> METAL_STATE = EntityDataManager.func_187226_a(MetalItemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private ItemStack stack = null;

    public MetalItemEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public MetalItemEntity(World worldIn, LivingEntity shooter, MetalTypes metalType) {
        super((EntityType)EntityRegister.METAL.get(), worldIn, shooter);
        this.setMetalType(metalType);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(METAL_TYPE, (Object)MetalTypes.EMPTY.ordinal());
        this.field_70180_af.func_187214_a(METAL_STATE, (Object)MetalStates.ABSORB.ordinal());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        boolean bl = this.field_70145_X = this.getMetalState() != MetalStates.SHOOT;
        if (!this.field_70170_p.field_72995_K && this.getThrower() != null && this.getThrower() instanceof MagnetShroomEntity) {
            MagnetShroomEntity thrower = (MagnetShroomEntity)this.getThrower();
            if (this.func_70068_e((Entity)thrower) <= 3.0) {
                if (this.getMetalState() == MetalStates.ABSORB) {
                    thrower.setMetalType(this.getMetalType());
                    this.func_70106_y();
                } else if (this.getMetalState() == MetalStates.BULLET) {
                    this.setMetalState(MetalStates.WAIT);
                }
            }
            if (this.getMetalState() == MetalStates.BULLET || this.getMetalState() == MetalStates.ABSORB) {
                Vector3d vec = thrower.func_213303_ch().func_72441_c(0.0, (double)thrower.func_213302_cg(), 0.0).func_178788_d(this.func_213303_ch());
                double speed = 0.8;
                vec = vec.func_72432_b().func_216372_d(speed, speed, speed);
                this.func_213317_d(vec);
            } else if (this.getMetalState() == MetalStates.WAIT) {
                LivingEntity target = this.getAttackTarget(thrower);
                if (target == null) {
                    this.func_213293_j(0.0, 0.0, 0.0);
                    return;
                }
                this.setMetalState(MetalStates.SHOOT);
                Vector3d vec = target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch());
                this.shootPea(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.4f);
            }
        }
    }

    private LivingEntity getAttackTarget(MagnetShroomEntity thrower) {
        if (this.field_70173_aa % 50 != 0) {
            return null;
        }
        List list = this.field_70170_p.func_175647_a(LivingEntity.class, EntityUtil.getEntityAABB((Entity)thrower, 20.0, 20.0), entity -> EntityUtil.checkCanEntityAttack((Entity)thrower, (Entity)entity));
        if (list.size() == 0) {
            return null;
        }
        int pos = thrower.func_70681_au().nextInt(list.size());
        return (LivingEntity)list.get(pos);
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity target = ((EntityRayTraceResult)result).func_216348_a();
            if (this.getMetalState() == MetalStates.SHOOT && this.checkCanAttack(target)) {
                target.field_70172_ad = 0;
                target.func_70097_a((DamageSource)PVZDamageSource.causeAppeaseDamage(this, (Entity)this.getThrower()), this.getAttackDamage());
                EntityUtil.playSound(this, (SoundEvent)SoundRegister.METAL_HIT.get());
                flag = true;
            }
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag || !this.checkLive(result)) {
            this.func_70106_y();
        }
    }

    @Override
    protected boolean checkLive(RayTraceResult result) {
        if (this.getMetalState() != MetalStates.SHOOT || result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return true;
        }
        return super.checkLive(result);
    }

    @Override
    protected float getAttackDamage() {
        return 50.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.2f, 0.2f, false);
    }

    @Override
    protected int getMaxLiveTick() {
        return 1200;
    }

    public ItemStack func_184543_l() {
        return this.stack == null ? (this.stack = new ItemStack((IItemProvider)MetalTypes.getMetalItem(this.getMetalType()))) : this.stack;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("metal_type", this.getMetalType().ordinal());
        compound.func_74768_a("metal_state", this.getMetalState().ordinal());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("metal_type")) {
            this.setMetalType(MetalTypes.values()[compound.func_74762_e("metal_type")]);
        }
        if (compound.func_74764_b("metal_state")) {
            this.setMetalState(MetalStates.values()[compound.func_74762_e("metal_state")]);
        }
    }

    public MetalTypes getMetalType() {
        return MetalTypes.values()[(Integer)this.field_70180_af.func_187225_a(METAL_TYPE)];
    }

    public void setMetalType(MetalTypes type) {
        this.field_70180_af.func_187227_b(METAL_TYPE, (Object)type.ordinal());
    }

    public MetalStates getMetalState() {
        return MetalStates.values()[(Integer)this.field_70180_af.func_187225_a(METAL_STATE)];
    }

    public void setMetalState(MetalStates type) {
        this.field_70180_af.func_187227_b(METAL_STATE, (Object)type.ordinal());
    }

    public static enum MetalStates {
        ABSORB,
        BULLET,
        WAIT,
        SHOOT;

    }
}

