/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet.itembullet;

import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.entity.bullet.itembullet.PVZItemBulletEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.entity.plant.flame.TorchWoodEntity;
import com.hungteen.pvz.entity.plant.interfaces.IIcePlant;
import com.hungteen.pvz.entity.zombie.zombotany.PeaShooterZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.WeaponUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class PeaEntity
extends PVZItemBulletEntity {
    private static final DataParameter<Integer> PEA_STATE = EntityDataManager.func_187226_a(PeaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PEA_TYPE = EntityDataManager.func_187226_a(PeaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int power = 0;
    private TorchWoodEntity torchWood = null;

    public PeaEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public PeaEntity(World worldIn, LivingEntity shooter, Type peaType, State peaState) {
        super((EntityType)EntityRegister.PEA.get(), worldIn, shooter);
        this.setPeaState(peaState);
        this.setPeaType(peaType);
        this.func_213323_x_();
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PEA_STATE, (Object)State.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(PEA_TYPE, (Object)Type.NORMAL.ordinal());
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity target = ((EntityRayTraceResult)result).func_216348_a();
            if (this.checkCanAttack(target)) {
                target.field_70172_ad = 0;
                this.dealPeaDamage(target);
                flag = true;
            }
            if (target instanceof TorchWoodEntity) {
                TorchWoodEntity tmp = (TorchWoodEntity)target;
                if (this.torchWood == null || !this.torchWood.func_70028_i((Entity)tmp)) {
                    this.torchWood = tmp;
                    if (this.torchWood.IsSuperFlame()) {
                        if (this.getPeaState() == State.ICE) {
                            this.setPeaState(State.FIRE);
                        } else if (this.getPeaState().ordinal() < State.BLUE_FIRE.ordinal()) {
                            this.setPeaState(State.BLUE_FIRE);
                        }
                    } else if (this.getPeaState() == State.ICE) {
                        this.setPeaState(State.NORMAL);
                    } else if (this.getPeaState() == State.NORMAL) {
                        this.setPeaState(State.FIRE);
                    }
                }
            }
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag || !this.checkLive(result)) {
            this.func_70106_y();
        }
    }

    private void dealPeaDamage(Entity target) {
        float damage = this.getFixDamage();
        if (this.getPeaState() == State.NORMAL) {
            target.func_70097_a((DamageSource)PVZDamageSource.causeAppeaseDamage(this, (Entity)this.getThrower()), damage);
        } else if (this.getPeaState() == State.ICE) {
            PVZDamageSource source = PVZDamageSource.causeIceDamage(this, (Entity)this.getThrower());
            LivingEntity owner = this.getThrower();
            if (owner instanceof IIcePlant) {
                source.addEffect(((IIcePlant)owner).getColdEffect());
            } else if (owner instanceof PlayerEntity) {
                ((PlayerEntity)owner).getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                    int lvl = l.getPlayerData().getPlantStats().getPlantLevel(Plants.SNOW_PEA);
                    source.addEffect(WeaponUtil.getPeaGunColdEffect(lvl));
                });
            }
            target.func_70097_a((DamageSource)source, damage);
        } else if (this.getPeaState() == State.FIRE || this.getPeaState() == State.BLUE_FIRE) {
            target.func_70097_a((DamageSource)PVZDamageSource.causeFireDamage(this, (Entity)this.getThrower()), damage);
        }
    }

    @Override
    protected boolean shouldHit(Entity target) {
        return super.shouldHit(target) || target instanceof TorchWoodEntity;
    }

    private float getFixDamage() {
        float damage = this.attackDamage;
        damage *= 1.0f + (float)this.power * 1.0f / 5.0f;
        if (this.getPeaType() == Type.BIG) {
            damage += 20.0f;
        } else if (this.getPeaType() == Type.HUGE) {
            damage += 75.0f;
        }
        if (this.getPeaState() == State.FIRE) {
            damage *= 2.0f;
        } else if (this.getPeaState() == State.BLUE_FIRE) {
            damage *= 3.0f;
        }
        return damage;
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof TorchWoodEntity) {
            return 2.0f;
        }
        if (this.getThrower() instanceof PlantShooterEntity) {
            return ((PlantShooterEntity)this.getThrower()).getAttackDamage();
        }
        if (this.getThrower() instanceof PlayerEntity) {
            return 2.0f;
        }
        if (this.getThrower() instanceof PeaShooterZombieEntity) {
            return ((PeaShooterZombieEntity)this.getThrower()).getAttackDamage();
        }
        return 0.0f;
    }

    @Override
    protected int getMaxLiveTick() {
        return 40;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.getPeaType() == Type.NORMAL) {
            return new EntitySize(0.2f, 0.2f, false);
        }
        if (this.getPeaType() == Type.BIG) {
            return new EntitySize(0.4f, 0.4f, false);
        }
        if (this.getPeaType() == Type.HUGE) {
            return new EntitySize(0.6f, 0.6f, false);
        }
        return new EntitySize(0.2f, 0.2f, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("peaState", this.getPeaState().ordinal());
        compound.func_74768_a("peaType", this.getPeaType().ordinal());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("peaState")) {
            this.setPeaState(State.values()[compound.func_74762_e("peaState")]);
        }
        if (compound.func_74764_b("peaType")) {
            this.setPeaType(Type.values()[compound.func_74762_e("peaType")]);
        }
    }

    @Override
    protected float getGravityVelocity() {
        return 0.002f;
    }

    public State getPeaState() {
        return State.values()[(Integer)this.field_70180_af.func_187225_a(PEA_STATE)];
    }

    public void setPeaState(State state) {
        this.field_70180_af.func_187227_b(PEA_STATE, (Object)state.ordinal());
    }

    public Type getPeaType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(PEA_TYPE)];
    }

    public void setPeaType(Type type) {
        this.field_70180_af.func_187227_b(PEA_TYPE, (Object)type.ordinal());
    }

    public ItemStack func_184543_l() {
        if (this.getPeaState() == State.NORMAL) {
            return new ItemStack((IItemProvider)ItemRegister.PEA.get());
        }
        if (this.getPeaState() == State.ICE) {
            return new ItemStack((IItemProvider)ItemRegister.SNOW_PEA.get());
        }
        if (this.getPeaState() == State.FIRE) {
            return new ItemStack((IItemProvider)ItemRegister.FLAME_PEA.get());
        }
        if (this.getPeaState() == State.BLUE_FIRE) {
            return new ItemStack((IItemProvider)ItemRegister.BLUE_FLAME_PEA.get());
        }
        return new ItemStack((IItemProvider)ItemRegister.PEA.get());
    }

    public void setPower(int lvl) {
        this.power = lvl;
    }

    public static enum State {
        ICE,
        NORMAL,
        FIRE,
        BLUE_FIRE,
        ELECTRICITY;

    }

    public static enum Type {
        NORMAL,
        BIG,
        HUGE;

    }
}

