/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.creature;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.ai.WaterTemptGoal;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.zombie.poolday.SnorkelZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FoodieZombieEntity
extends AnimalEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegister.FAKE_BRAIN.get(), (IItemProvider)ItemRegister.REAL_BRAIN.get()});
    private static final DataParameter<Integer> GEN_TICK = EntityDataManager.func_187226_a(FoodieZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int lvl;
    protected static final int MAX_LVL = 10;

    public FoodieZombieEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_213323_x_();
        this.lvl = 1;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GEN_TICK, (Object)-1);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterTemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getGenTick() >= 0) {
            this.setGenTick(this.getGenTick() - 1);
            if (this.getGenTick() == 0) {
                this.produceSun();
            }
        }
    }

    protected void produceSun() {
        SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_70170_p);
        sun.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
        sun.setAmount(this.getSunAmount());
        this.field_70170_p.func_217376_c((Entity)sun);
    }

    protected int getSunAmount() {
        return 20 + this.lvl * 5;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70877_b(itemstack)) {
            if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && this.getGenTick() == -1 && this.func_204701_dC()) {
                this.func_175505_a(player, itemstack);
                this.func_184185_a((SoundEvent)SoundRegister.SLURP.get(), 1.0f, 1.0f);
                this.func_146082_f(player);
                this.setGenTick(this.getGenCD());
                player.func_226292_a_(hand, true);
                return ActionResultType.CONSUME;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(player, itemstack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                return ActionResultType.CONSUME;
            }
            if (itemstack.func_77973_b() == ItemRegister.REAL_BRAIN.get() && this.lvl <= 10) {
                ++this.lvl;
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.FAIL;
    }

    private int getGenCD() {
        return 600 - this.lvl * 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.func_70631_g_()) {
            return EntitySize.func_220314_b((float)0.3f, (float)0.3f);
        }
        return EntitySize.func_220314_b((float)0.7f, (float)0.5f);
    }

    public AgeableEntity func_241840_a(ServerWorld level, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)EntityRegister.FOODIE_ZOMBIE.get()).func_200721_a((World)level);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            this.func_70106_y();
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            this.doDeathSpawn();
        }
    }

    private void doDeathSpawn() {
        if (!this.field_70170_p.field_72995_K) {
            SnorkelZombieEntity snorkel = (SnorkelZombieEntity)((EntityType)EntityRegister.SNORKEL_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            snorkel.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.field_70170_p.func_217376_c((Entity)snorkel);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    public int getGenTick() {
        return (Integer)this.field_70180_af.func_187225_a(GEN_TICK);
    }

    public void setGenTick(int tick) {
        this.field_70180_af.func_187227_b(GEN_TICK, (Object)tick);
    }

    protected ResourceLocation func_184647_J() {
        return PVZLoot.FOODIE_ZOMBIE;
    }

    public static boolean canSpawn(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_lvl")) {
            this.lvl = compound.func_74762_e("zombie_lvl");
        }
        if (compound.func_74764_b("gen_tick")) {
            this.setGenTick(compound.func_74762_e("gen_tick"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_lvl", this.lvl);
        compound.func_74768_a("gen_tick", this.getGenTick());
    }

    static class MoveHelperController
    extends MovementController {
        private final FoodieZombieEntity zombie;

        public MoveHelperController(FoodieZombieEntity zombie) {
            super((MobEntity)zombie);
            this.zombie = zombie;
        }

        public void func_75641_c() {
            if (this.zombie.func_70090_H()) {
                this.zombie.func_213317_d(this.zombie.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.zombie.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.zombie.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.zombie.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.zombie.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.zombie.field_70761_aq = this.zombie.field_70177_z = this.func_75639_a(this.zombie.field_70177_z, f, 10.0f);
                    this.zombie.field_70759_as = this.zombie.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.zombie.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    if (this.zombie.func_70090_H()) {
                        this.zombie.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.zombie.field_70125_A = this.func_75639_a(this.zombie.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.zombie.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.zombie.field_70125_A * ((float)Math.PI / 180)));
                        this.zombie.field_191988_bg = f3 * f1;
                        this.zombie.field_70701_bs = -f4 * f1;
                    } else {
                        this.zombie.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.zombie.func_70659_e(0.0f);
                this.zombie.func_184646_p(0.0f);
                this.zombie.func_70657_f(0.0f);
                this.zombie.func_191989_p(0.0f);
            }
        }
    }
}

