/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.drop;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;

public abstract class DropEntity
extends MobEntity {
    private static final DataParameter<Integer> AMOUNT = EntityDataManager.func_187226_a(DropEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(DropEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int liveTime = 0;

    public DropEntity(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184224_h(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AMOUNT, (Object)1);
        this.field_70180_af.func_187214_a(STATE, (Object)DropStates.NORMAL.ordinal());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean bl = this.field_70145_X = this.getDropState() != DropStates.NORMAL;
        if (!this.field_70170_p.field_72995_K) {
            if (this.getDropState() == DropStates.NORMAL) {
                ++this.liveTime;
            }
            if (this.liveTime >= this.getMaxLiveTick()) {
                this.func_70106_y();
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_70067_L() {
        return false;
    }

    protected abstract int getMaxLiveTick();

    public void func_184206_a(DataParameter<?> key) {
        if (AMOUNT.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_226295_cZ_() {
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("live_time")) {
            this.liveTime = compound.func_74762_e("live_time");
        }
        if (compound.func_74764_b("drop_amount")) {
            this.setAmount(compound.func_74762_e("drop_amount"));
        }
        if (compound.func_74764_b("drop_state")) {
            this.setDropState(DropStates.values()[compound.func_74762_e("drop_state")]);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("live_time", this.liveTime);
        compound.func_74768_a("drop_amount", this.getAmount());
        compound.func_74768_a("drop_state", this.getDropState().ordinal());
    }

    public int getAmount() {
        return (Integer)this.field_70180_af.func_187225_a(AMOUNT);
    }

    public void setAmount(int num) {
        this.field_70180_af.func_187227_b(AMOUNT, (Object)num);
    }

    public DropStates getDropState() {
        return DropStates.values()[(Integer)this.field_70180_af.func_187225_a(STATE)];
    }

    public void setDropState(DropStates state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state.ordinal());
    }

    public static enum DropStates {
        NORMAL,
        ABSORB,
        STEAL;

    }
}

