/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.misc;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.misc.AbstractOwnerEntity;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.List;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LawnMowerEntity
extends AbstractOwnerEntity {
    private static final DataParameter<Boolean> START_RUN = EntityDataManager.func_187226_a(LawnMowerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public LawnMowerEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_213317_d(Vector3d.field_186680_a);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(START_RUN, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H() || this.field_70173_aa >= (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.LawnMowerLiveTick.get()) {
                this.func_70106_y();
                return;
            }
            if (this.isStartRun()) {
                this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_186662_g(0.5), target -> EntityUtil.checkCanEntityAttack(this, target)).forEach(target -> {
                    if (EntityUtil.canEntityBeRemoved(target)) {
                        target.func_70106_y();
                    }
                });
                double angle = (double)this.field_70177_z * Math.PI / 180.0;
                double dx = -Math.sin(angle);
                double dz = Math.cos(angle);
                double speed = 0.4;
                this.func_213293_j(dx * speed, this.func_213322_ci().func_82617_b(), dz * speed);
            } else {
                --this.field_70173_aa;
                List list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_186662_g(1.0), target -> EntityUtil.checkCanEntityAttack(this, target));
                if (!list.isEmpty()) {
                    this.onStartRun((Entity)list.get(0));
                }
            }
        }
        if (this.field_70173_aa < 5) {
            BlockPos pos = this.func_233580_cy_();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, this.func_226278_cu_(), (double)pos.func_177952_p() + 0.5);
        }
        this.tickMove();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        if (!this.isStartRun() && hand == Hand.MAIN_HAND && player.func_184614_ca().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_191521_c(new ItemStack((IItemProvider)ItemRegister.LAWN_MOWER.get()));
                this.func_70106_y();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_70067_L() {
        return true;
    }

    private void onStartRun(Entity target) {
        this.func_200602_a(EntityAnchorArgument.Type.FEET, target.func_213303_ch());
        this.setStartRun(true);
        EntityUtil.playSound(this, (SoundEvent)SoundRegister.LAWN_MOWER.get());
    }

    public void setPlacer(PlayerEntity player) {
        this.setOwner((LivingEntity)player);
        this.field_70177_z = player.func_174811_aO().func_185119_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)0.8f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("start_running")) {
            this.setStartRun(compound.func_74767_n("start_running"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("start_running", this.isStartRun());
    }

    public void setStartRun(boolean is) {
        this.field_70180_af.func_187227_b(START_RUN, (Object)is);
    }

    public boolean isStartRun() {
        return (Boolean)this.field_70180_af.func_187225_a(START_RUN);
    }
}

