/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.appease;

import com.hungteen.pvz.entity.ai.attack.ShooterAttackGoal;
import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.StarEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class StarFruitEntity
extends PlantShooterEntity {
    public static final float PER_ANGLE = 72.0f;
    public int lightTick = 0;

    public StarFruitEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new ShooterAttackGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 2.0f, 0.0f));
    }

    @Override
    public void normalPlantTick() {
        if (this.field_70170_p.field_72995_K) {
            if (this.lightTick > 0) {
                --this.lightTick;
            }
            if (this.getAttackTime() > 0) {
                this.lightTick = 8;
            }
        }
        super.normalPlantTick();
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() == 2;
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 100;
        }
        if (this.isPlantInStage(2)) {
            return 150;
        }
        if (this.isPlantInStage(3)) {
            return 200;
        }
        return 200;
    }

    @Override
    public void shootBullet() {
        float now = this.field_70177_z + 180.0f;
        for (int i = 0; i < 5; ++i) {
            this.shootStarByAngle(now);
            now += 72.0f;
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SNOW_SHOOT.get());
    }

    private void shootStarByAngle(float angle) {
        double vx = -MathHelper.func_76126_a((float)(angle *= 0.01745328f));
        double vz = MathHelper.func_76134_b((float)angle);
        StarEntity.StarTypes type = this.isPlantInSuperMode() ? StarEntity.StarTypes.HUGE : StarEntity.StarTypes.NORMAL;
        StarEntity pea = new StarEntity(this.field_70170_p, (LivingEntity)this, type, StarEntity.StarStates.YELLOW);
        pea.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.2f, this.func_226281_cx_());
        pea.func_213293_j(vx, 0.0, vz);
        this.field_70170_p.func_217376_c((Entity)pea);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.5f);
    }

    @Override
    public double getMaxShootAngle() {
        return 40.0;
    }

    @Override
    public void startShootAttack() {
        this.updateFacing();
        this.setAttackTime(2);
    }

    private void updateFacing() {
        float now = this.func_70681_au().nextFloat() * 3.14159f * 2.0f;
        double dx = Math.sin(now);
        double dz = Math.cos(now);
        double dy = 0.0;
        this.func_200602_a(EntityAnchorArgument.Type.FEET, this.func_213303_ch().func_72441_c(dx, dy, dz));
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.STAR_FRUIT;
    }
}

