/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.arma;

import com.hungteen.pvz.entity.bullet.ButterEntity;
import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.arma.KernelPultEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ButterPultEntity
extends KernelPultEntity {
    public ButterPultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCurrentBullet(KernelPultEntity.CornTypes.BUTTER);
    }

    @Override
    protected Optional<PultBulletEntity> pultKernel(LivingEntity target, boolean isSuper) {
        if (target == null) {
            return Optional.empty();
        }
        ButterEntity bullet = new ButterEntity(this.field_70170_p, (LivingEntity)this);
        bullet.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
        bullet.shootPultBullet(target);
        this.field_70170_p.func_217376_c((Entity)bullet);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        this.setCurrentBullet(KernelPultEntity.CornTypes.KERNEL);
        return Optional.of(bullet);
    }

    @Override
    protected void changeBullet() {
        this.setCurrentBullet(KernelPultEntity.CornTypes.BUTTER);
    }

    @Override
    public float getSuperRange() {
        if (this.isPlantInStage(1)) {
            return 15.0f;
        }
        if (this.isPlantInStage(2)) {
            return 20.0f;
        }
        return 25.0f;
    }

    @Override
    public float getButterDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 0.1f * (float)lvl;
        }
        return 2.0f;
    }

    @Override
    public int getButterDuration() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 72 + 8 * lvl;
        }
        return 240;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BUTTER_PULT;
    }
}

