/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.arma;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.itembullet.CabbageEntity;
import com.hungteen.pvz.entity.plant.base.PlantPultEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CabbagePultEntity
extends PlantPultEntity {
    public CabbagePultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getPultRange(), 11.0f, 10.0f));
    }

    @Override
    public void pultBullet() {
        LivingEntity target = this.func_70638_az();
        this.pultCabbage(target);
    }

    @Override
    protected void doSuperAttackToTarget(LivingEntity target) {
        this.pultCabbage(target).ifPresent(cabbage -> cabbage.setCabbageType(CabbageEntity.CabbageTypes.POWER));
    }

    private Optional<CabbageEntity> pultCabbage(LivingEntity target) {
        if (target == null) {
            return Optional.empty();
        }
        CabbageEntity cabbage = new CabbageEntity(this.field_70170_p, (LivingEntity)this);
        cabbage.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
        cabbage.shootPultBullet(target);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        this.field_70170_p.func_217376_c((Entity)cabbage);
        return Optional.of(cabbage);
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 3.75f + 0.25f * (float)lvl;
        }
        return 9.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.0f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CABBAGE_PULT;
    }
}

