/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.arma;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.MelonEntity;
import com.hungteen.pvz.entity.plant.base.PlantPultEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class MelonPultEntity
extends PlantPultEntity {
    public MelonPultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getPultRange(), 11.0f, 10.0f));
    }

    @Override
    public void pultBullet() {
        LivingEntity target = this.func_70638_az();
        this.pultMelon(target);
    }

    @Override
    protected void doSuperAttackToTarget(LivingEntity target) {
        this.pultMelon(target).ifPresent(melon -> melon.setMelonType(MelonEntity.MelonTypes.POWER));
    }

    private Optional<MelonEntity> pultMelon(LivingEntity target) {
        if (target == null) {
            return Optional.empty();
        }
        MelonEntity melon = new MelonEntity(this.field_70170_p, (LivingEntity)this);
        melon.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.5, this.func_226281_cx_());
        melon.shootPultBullet(target);
        melon.setMelonState(this.getThrowMelonState());
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        this.field_70170_p.func_217376_c((Entity)melon);
        return Optional.of(melon);
    }

    protected MelonEntity.MelonStates getThrowMelonState() {
        return MelonEntity.MelonStates.NORMAL;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 7.5f + 0.5f * (float)lvl;
        }
        return 18.0f;
    }

    public float getSplashDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 2.75f + 0.25f * (float)lvl;
        }
        return 8.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)1.0f);
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.WINTER_MELON;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.MELON_PULT;
    }
}

