/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.assist;

import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BloverEntity
extends PlantBomberEntity {
    public BloverEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb() {
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() == 5) {
            this.blow();
        }
    }

    private void blow() {
        if (!this.field_70170_p.field_72995_K) {
            float len = 30.0f;
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, len, len);
            EntityUtil.getEntityTargetableEntity((Entity)this, aabb).forEach(target -> {
                if (EntityUtil.isEntityInSky((Entity)target)) {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), this.getAttackDamage());
                    Vector3d speed = target.func_213322_ci();
                    double dx = target.func_226277_ct_() - this.func_226277_ct_();
                    double dz = target.func_226281_cx_() - this.func_226281_cx_();
                    double tot = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                    double lvl = (float)this.getForceLevel() * 2.5f;
                    double speedX = dx / tot * lvl;
                    double speedZ = dz / tot * lvl;
                    target.func_213293_j(speed.field_72450_a + speedX, speed.field_72448_b, speed.field_72449_c + speedZ);
                }
            });
            this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, len, len), player -> !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)player)).forEach(player -> PlayerUtil.addPlayerStats(player, Resources.NO_FOG_TICK, 2400 * this.getForceLevel()));
        }
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundRegister.BLOVER.get();
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 28.5f + 1.5f * (float)lvl;
        }
        return 60.0f;
    }

    public int getForceLevel() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getReadyTime() {
        return 50;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)1.5f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BLOVER;
    }
}

