/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.assist;

import com.hungteen.pvz.entity.drop.CoinEntity;
import com.hungteen.pvz.entity.drop.DropEntity;
import com.hungteen.pvz.entity.drop.JewelEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class GoldMagnetEntity
extends PVZPlantEntity {
    private final Set<DropEntity> coinSet = new HashSet<DropEntity>();
    private final int MaxSearchTick = 60;
    private Optional<PlayerEntity> player = Optional.empty();

    public GoldMagnetEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOwnerUUID().isPresent()) {
                this.player = Optional.ofNullable(this.field_70170_p.func_217371_b(this.getOwnerUUID().get()));
                this.tickCoinSet();
            }
            this.setAttackTime(this.coinSet.size());
        }
    }

    private void tickCoinSet() {
        HashSet tmp = new HashSet();
        this.coinSet.forEach(coin -> {
            if (coin != null && !coin.field_70128_L && coin.getDropState() == DropEntity.DropStates.ABSORB) {
                tmp.add(coin);
            }
        });
        this.coinSet.clear();
        this.coinSet.addAll(tmp);
        tmp.clear();
        if (!this.checkCanWorkNow()) {
            this.coinSet.forEach(coin -> coin.setDropState(DropEntity.DropStates.NORMAL));
            this.coinSet.clear();
            return;
        }
        if (this.field_70173_aa % this.MaxSearchTick == 0) {
            float range = this.getSearchRange();
            this.field_70170_p.func_175647_a(DropEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), drop -> (drop instanceof CoinEntity || drop instanceof JewelEntity) && drop.getDropState() == DropEntity.DropStates.NORMAL && !this.coinSet.contains(drop)).forEach(coin -> {
                coin.setDropState(DropEntity.DropStates.ABSORB);
                this.coinSet.add((DropEntity)((Object)coin));
            });
            if (!this.coinSet.isEmpty()) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.MAGNET.get());
            }
        }
        this.coinSet.forEach(coin -> {
            double speed = 0.3;
            Vector3d now = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_());
            Vector3d vec = now.func_178788_d(coin.func_213303_ch());
            if (vec.func_72433_c() <= 1.0) {
                this.onCollectCoin((DropEntity)((Object)coin));
            } else {
                coin.func_213317_d(vec.func_72432_b().func_186678_a(speed));
            }
        });
    }

    private void onCollectCoin(DropEntity drop) {
        if (!this.player.isPresent()) {
            return;
        }
        if (drop instanceof CoinEntity) {
            PlayerUtil.addPlayerStats(this.player.get(), Resources.MONEY, drop.getAmount());
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.COIN_PICK.get());
        } else if (drop instanceof JewelEntity) {
            PlayerUtil.addPlayerStats(this.player.get(), Resources.GEM_NUM, drop.getAmount());
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JEWEL_PICK.get());
        }
        drop.func_70106_y();
    }

    public int getSearchRange() {
        if (this.isPlantInStage(1)) {
            return 10;
        }
        if (this.isPlantInStage(2)) {
            return 15;
        }
        return 20;
    }

    protected boolean checkCanWorkNow() {
        return this.player.isPresent();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)1.3f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GOLD_MAGNET;
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }
}

