/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.base;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IDefender;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class PlantDefenderEntity
extends PVZPlantEntity
implements IDefender {
    private static final DataParameter<Float> DEFENCE_LIFE = EntityDataManager.func_187226_a(PlantDefenderEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public PlantDefenderEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DEFENCE_LIFE, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, this.getAttractRange(), this.getAttractRange()){

            @Override
            protected boolean checkOther(LivingEntity entity) {
                if (entity instanceof MobEntity) {
                    return !(((MobEntity)entity).func_70638_az() instanceof PlantDefenderEntity);
                }
                return false;
            }
        });
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.attract();
            this.func_70624_b(null);
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setDefenceLife(this.getSuperLife());
        this.attract();
    }

    @Override
    public void attract() {
        float range = this.getAttractRange();
        for (LivingEntity target : EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range))) {
            this.attract(target);
        }
    }

    public void attract(LivingEntity target) {
        if (target instanceof MobEntity && !(((MobEntity)target).func_70638_az() instanceof PlantDefenderEntity)) {
            ((MobEntity)target).func_70624_b((LivingEntity)this);
        }
    }

    @Override
    public float getCurrentHealth() {
        return super.getCurrentHealth() + this.getDefenceLife();
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        super.func_184199_a(player, vec3d, hand);
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof PlantCardItem && this.func_110143_aJ() != this.func_110138_aP()) {
            PlantCardItem cardItem = (PlantCardItem)stack.func_77973_b();
            if (cardItem.plantType == this.getPlantEnumName()) {
                if (!this.field_70170_p.field_72995_K) {
                    PlantCardItem.checkSunAndHealPlant(player, this, cardItem, stack);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), (double)((this.func_70681_au().nextFloat() - 0.5f) / 8.0f), (double)0.05f, (double)((this.func_70681_au().nextFloat() - 0.5f) / 8.0f));
                    }
                }
                return ActionResultType.CONSUME;
            }
            if (cardItem instanceof ImitaterCardItem && ((ImitaterCardItem)cardItem).isPlantTypeEqual(stack, this.getPlantEnumName())) {
                if (!this.field_70170_p.field_72995_K) {
                    PlantCardItem.checkSunAndHealPlant(player, this, cardItem, stack);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), (double)((this.func_70681_au().nextFloat() - 0.5f) / 8.0f), (double)0.05f, (double)((this.func_70681_au().nextFloat() - 0.5f) / 8.0f));
                    }
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.FAIL;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        amount = this.pumpkinReduceDamage(source, amount);
        if (!this.field_70170_p.field_72995_K && this.getDefenceLife() > 0.0f) {
            if (this.getDefenceLife() > amount) {
                this.setDefenceLife(this.getDefenceLife() - amount);
                amount = 0.0f;
            } else {
                amount -= this.getDefenceLife();
                this.setDefenceLife(0.0f);
            }
        }
        if (amount == 0.0f) {
            amount = 0.001f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public float getAttractRange() {
        return 3.0f;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    public float getDefenceLife() {
        return ((Float)this.field_70180_af.func_187225_a(DEFENCE_LIFE)).floatValue();
    }

    public void setDefenceLife(float life) {
        this.field_70180_af.func_187227_b(DEFENCE_LIFE, (Object)Float.valueOf(life));
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("defence_life")) {
            this.setDefenceLife(compound.func_74760_g("defence_life"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("defence_life", this.getDefenceLife());
    }
}

