/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.base;

import com.hungteen.pvz.entity.ai.ProducerGenGoal;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IProducer;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class PlantProducerEntity
extends PVZPlantEntity
implements IProducer {
    private static final DataParameter<Boolean> IS_GEN_TIME = EntityDataManager.func_187226_a(PlantProducerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int genCD;

    public PlantProducerEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeCharmed = false;
        this.genCD = this.getGenCD();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_GEN_TIME, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ProducerGenGoal(this));
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    protected void genSun(int num) {
        SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_70170_p);
        sun.setAmount(num);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, sun, this.func_233580_cy_(), 2);
        EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_gen_time")) {
            this.setIsGenTime(compound.func_74767_n("is_gen_time"));
        }
        if (compound.func_74764_b("gen_cd")) {
            this.genCD = compound.func_74762_e("gen_cd");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_gen_time", this.getIsGenTime());
        compound.func_74768_a("gen_cd", this.genCD);
    }

    public boolean getIsGenTime() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_GEN_TIME);
    }

    public void setIsGenTime(boolean is) {
        this.field_70180_af.func_187227_b(IS_GEN_TIME, (Object)is);
    }
}

