/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.base;

import com.hungteen.pvz.entity.ai.attack.PultAttackGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IPult;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public abstract class PlantPultEntity
extends PVZPlantEntity
implements IPult {
    protected boolean isSuperOut = false;

    public PlantPultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PultAttackGoal(this));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)this.getPultRange());
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() == this.getPultAnimTime() / 2) {
                if (this.isPlantInSuperMode() && !this.isSuperOut) {
                    this.isSuperOut = true;
                    this.superAttack();
                } else {
                    this.pultBullet();
                }
            }
        }
    }

    protected void superAttack() {
        float range = this.getSuperRange();
        EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(target -> this.doSuperAttackToTarget((LivingEntity)target));
    }

    protected abstract void doSuperAttackToTarget(LivingEntity var1);

    @Override
    public boolean shouldPult() {
        return this.canPlantNormalUpdate();
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return this.checkY(entity) && super.canPlantTarget(entity);
    }

    protected boolean checkY(LivingEntity target) {
        return this.func_226278_cu_() + 10.0 >= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    public float getSuperRange() {
        if (this.isPlantInStage(1)) {
            return 10.0f;
        }
        if (this.isPlantInStage(2)) {
            return 15.0f;
        }
        return 20.0f;
    }

    @Override
    public float getPultRange() {
        return 40.0f;
    }

    @Override
    public void startPultAttack() {
        this.setAttackTime(this.getPultAnimTime());
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.isSuperOut = false;
        this.startPultAttack();
    }

    public int getPultAnimTime() {
        return 20;
    }

    @Override
    public int getPultCD() {
        return 60;
    }

    @Override
    public int getSuperTimeLength() {
        return 60;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_plant_super_out")) {
            this.isSuperOut = compound.func_74767_n("is_plant_super_out");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_plant_super_out", this.isSuperOut);
    }
}

