/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.enforce;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SquashEntity
extends PVZPlantEntity {
    protected int extraChance = 0;
    private final int range = 3;
    private int restTick = 0;
    private final int CD = 20;

    public SquashEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 3.0f, 1.0f));
    }

    @Override
    protected boolean shouldLockXZ() {
        return false;
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.restTick > 0) {
                --this.restTick;
                return;
            }
            LivingEntity target = this.func_70638_az();
            if (target != null && EntityUtil.isSuitableTargetInRange((MobEntity)this, target, 3.0)) {
                this.func_70624_b(null);
            }
            if (this.func_70638_az() != null) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            if (this.getAttackTime() > 0) {
                if (EntityUtil.isOnGround((Entity)this) || EntityUtil.isOnSnow((Entity)this)) {
                    this.dealDamage();
                    if (this.extraChance > 0) {
                        --this.extraChance;
                    } else if (this.func_70681_au().nextInt(100) < this.getDeathChance()) {
                        this.func_70106_y();
                    }
                }
            } else if (this.func_70638_az() != null) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SQUASH_HMM.get());
                this.jumpToTarget(this.func_70638_az());
            }
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target)) {
            return false;
        }
        return super.shouldCollideWithEntity(target);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.field_70170_p.field_72995_K) {
            this.extraChance = this.getSuperBonusChance();
        }
    }

    protected void dealDamage() {
        this.setAttackTime(0);
        this.canCollideWithPlant = true;
        this.restTick = 20;
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.GROUND_SHAKE.get());
        for (Entity entity : EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, 0.5, 0.5))) {
            entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), this.getAttackDamage());
        }
    }

    private void jumpToTarget(LivingEntity target) {
        int tick = 10;
        this.canCollideWithPlant = false;
        Vector3d pos = target.func_213303_ch().func_178787_e(target.func_213322_ci().func_216372_d((double)tick, (double)tick, (double)tick));
        this.func_70107_b(pos.func_82615_a(), pos.func_82617_b() + (double)target.func_213302_cg() + 1.0, pos.func_82616_c());
        this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.0, this.func_213322_ci().func_82616_c());
        this.setAttackTime(1);
    }

    protected int getSuperBonusChance() {
        if (this.isPlantInStage(1)) {
            return 2;
        }
        if (this.isPlantInStage(2)) {
            return 3;
        }
        return 4;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 135 + 5 * lvl;
        }
        return 240.0f;
    }

    public int getDeathChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 90 - 5 * now;
        }
        return 70;
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return super.isPlantImmuneTo(source) || PVZDamageSource.isEnforceDamage(source) || source == DamageSource.field_76379_h;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SQUASH;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)1.5f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("extra_chance")) {
            this.extraChance = compound.func_74762_e("extra_chance");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("extra_chance", this.extraChance);
    }
}

