/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.enforce;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class TangleKelpEntity
extends PVZPlantEntity {
    public TangleKelpEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 1.0f, 2.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.func_184188_bt().isEmpty()) {
                    this.func_70106_y();
                    return;
                }
                this.func_213293_j(0.0, -0.03f, 0.0);
                if (this.getAttackTime() % 100 == 0) {
                    for (Entity target : this.func_184188_bt()) {
                        target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), this.getAttackDamage());
                    }
                }
                if (this.getAttackTime() >= 1000) {
                    this.func_70106_y();
                }
            }
            if (this.getAttackTime() == 0 && this.func_70638_az() != null) {
                this.setAttackTime(1);
                if (this.func_70638_az().func_184187_bx() != null) {
                    this.func_70638_az().func_184210_p();
                }
                this.func_70638_az().func_184205_a((Entity)this, true);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            }
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.field_70170_p.field_72995_K) {
            int cnt = this.getCount();
            for (Entity entity : EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, 25.0, 3.0))) {
                if (entity.func_70090_H()) {
                    --cnt;
                    TangleKelpEntity entity2 = (TangleKelpEntity)((EntityType)EntityRegister.TANGLE_KELP.get()).func_200721_a(this.field_70170_p);
                    entity2.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                    PlantUtil.copyPlantData(entity2, this);
                    this.field_70170_p.func_217376_c((Entity)entity2);
                }
                if (cnt > 0) continue;
                break;
            }
        }
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 13.75f + 0.25f * (float)lvl;
        }
        return 19.0f;
    }

    public double func_70042_X() {
        return 0.0;
    }

    private int getCount() {
        if (this.isPlantInStage(1)) {
            return 3;
        }
        if (this.isPlantInStage(2)) {
            return 4;
        }
        return 5;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.6f, 1.0f, false);
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return super.isPlantImmuneTo(source) || PVZDamageSource.isEnforceDamage(source);
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public boolean func_189652_ae() {
        return this.func_70090_H();
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.TANGLE_KELP;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }
}

