/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.enforce;

import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class UmbrellaLeafEntity
extends PVZPlantEntity {
    public static final int ANIM_TICK = 10;
    private int inc = 0;

    public UmbrellaLeafEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            this.tickLeaf();
            if (this.getAttackTime() == 0 && this.inc > 0) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            }
            this.setAttackTime(MathHelper.func_76125_a((int)(this.getAttackTime() + this.inc), (int)0, (int)10));
        }
    }

    private void tickLeaf() {
        float range = this.getProtectRange();
        List list = this.field_70170_p.func_175647_a(Entity.class, EntityUtil.getEntityAABB((Entity)this, range, 3.0), target -> {
            if (target instanceof PultBulletEntity) {
                return EntityUtil.checkCanEntityAttack((Entity)this, target);
            }
            if (target instanceof BungeeZombieEntity) {
                return EntityUtil.checkCanEntityAttack((Entity)this, target);
            }
            return false;
        });
        if (list.isEmpty()) {
            if (this.inc == -1 || this.getAttackTime() == 10) {
                this.inc = -1;
            }
            return;
        }
        this.inc = 1;
        list.forEach(target -> {
            if (target instanceof BungeeZombieEntity) {
                ((BungeeZombieEntity)target).pushBack();
            } else if (target instanceof PultBulletEntity) {
                ((PultBulletEntity)target).pushBack();
            }
        });
    }

    public float getProtectRange() {
        if (this.isPlantInStage(1)) {
            return 2.5f;
        }
        if (this.isPlantInStage(2)) {
            return 3.5f;
        }
        return 5.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.2f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.UMBRELLA_LEAF;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("anim_inc_num")) {
            this.inc = compound.func_74762_e("anim_inc_num");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("anim_inc_num", this.inc);
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }
}

