/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.entity.bullet.itembullet.FireCrackerEntity;
import com.hungteen.pvz.entity.misc.FireCrackersEntity;
import com.hungteen.pvz.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.ArrayList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BambooLordEntity
extends PlantCloserEntity {
    public static final int UP_CD = 20;
    public static final float UP_SPEED = 2.0f;

    public BambooLordEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() <= 0) {
                this.explode();
            }
        }
    }

    protected void explode() {
        int i;
        float range = 40.0f;
        ArrayList list = new ArrayList();
        EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(target -> {
            if (this.func_70635_at().func_75522_a((Entity)target)) {
                list.add(target);
            }
        });
        if (!list.isEmpty()) {
            for (i = 0; i < this.getSplitCount(); ++i) {
                int pos = this.func_70681_au().nextInt(list.size());
                FireCrackerEntity entity = new FireCrackerEntity(this.field_70170_p, (LivingEntity)this);
                entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                entity.shoot((Entity)list.get(pos));
                this.field_70170_p.func_217376_c((Entity)entity);
            }
        }
        for (i = 0; i < 3; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        this.func_70106_y();
    }

    @Override
    public void performAttack(LivingEntity target1) {
        if (this.getAttackTime() != 0) {
            return;
        }
        this.setAttackTime(20);
        for (int i = 0; i < 3; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        float range = 1.5f;
        EntityUtil.getAttackEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(target -> {
            target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage());
            target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
        });
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POTATO_MINE.get());
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        for (int i = 0; i < this.getCrackersNum(); ++i) {
            this.generateCrackers();
        }
    }

    private void generateCrackers() {
        float rotate = this.func_70681_au().nextFloat() * 2.0f * 3.14159f;
        int len = 10;
        double dx = Math.sin(rotate);
        double dz = Math.cos(rotate);
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = this.func_233580_cy_().func_177963_a(dx * (double)i * 2.0, 2.0, dz * (double)i * 2.0);
            FireCrackersEntity entity = new FireCrackersEntity(this.field_70170_p, (LivingEntity)this);
            entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            entity.setFuse(10 + 6 * i);
            this.field_70170_p.func_217376_c((Entity)entity);
        }
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 57.0f + (float)(3 * lvl);
        }
        return 120.0f;
    }

    public int getSplitCount() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 5;
            return now + 2;
        }
        return 5;
    }

    public int getCrackersNum() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)1.0f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BAMBOO_LORD;
    }
}

