/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class CherryBombEntity
extends PlantBomberEntity {
    public CherryBombEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb() {
        if (!this.field_70170_p.field_72995_K) {
            float len = this.getExpRange();
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, len, len);
            int deathCnt = 0;
            for (Entity target : EntityUtil.getAttackEntities((Entity)this, aabb)) {
                target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage());
                if (EntityUtil.isEntityValid(target)) continue;
                ++deathCnt;
            }
            PlayerEntity owner = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (owner != null && owner instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)owner, (Entity)this, deathCnt);
            }
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHERRY_BOMB.get());
        }
        for (int i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.RED_BOMB.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public float getExpRange() {
        return this.getPlantLvl() <= 10 ? 2.0f : 2.5f;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 145 + 5 * lvl;
        }
        return 250.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.9f, 1.0f, false);
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CHERRY_BOMB;
    }
}

