/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DoomShroomEntity
extends PlantBomberEntity {
    private final int destroyBlockHeight = 1;
    public static final float MAX_EXPLOSION_LEVEL = 500.0f;

    public DoomShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb() {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.getAttackEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, this.getAttackRange(), this.getAttackRange())).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage()));
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DOOM.get());
            ObjectArrayList list = new ObjectArrayList();
            int len = this.getDestroyBlockRange();
            if (len == 0) {
                return;
            }
            for (int i = -(--len); i <= len; ++i) {
                for (int j = -len; j <= len; ++j) {
                    for (int k = -1; k <= len; ++k) {
                        BlockPos pos = this.func_233580_cy_().func_177982_a(i, k, j);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        if (state.isAir((IBlockReader)this.field_70170_p, pos) || state.func_177230_c().func_149638_a() > 500.0f) continue;
                        TileEntity tileentity = state.hasTileEntity() ? this.field_70170_p.func_175625_s(pos) : null;
                        LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this);
                        loot.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(len));
                        state.func_215693_a(loot).forEach(stack -> {
                            for (int l = 0; l < list.size(); ++l) {
                                Pair pair = (Pair)list.get(l);
                                ItemStack itemstack = (ItemStack)pair.getFirst();
                                if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
                                ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
                                list.set(l, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
                                if (!list.isEmpty()) continue;
                                return;
                            }
                            list.add((Object)Pair.of((Object)stack, (Object)pos));
                        });
                        this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    }
                }
            }
            for (Pair pair : list) {
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        } else {
            this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.DOOM.get(), this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private int getDestroyBlockRange() {
        return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.DoomRange.get();
    }

    public float getAttackRange() {
        if (this.isPlantInStage(1)) {
            return 5.0f;
        }
        if (this.isPlantInStage(2)) {
            return 6.0f;
        }
        return 7.0f;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 232 + 8 * lvl;
        }
        return 400.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.5f);
    }

    @Override
    public int getReadyTime() {
        return 40;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.DOOM_SHROOM;
    }
}

