/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.entity.bullet.itembullet.PotatoEntity;
import com.hungteen.pvz.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class PotatoMineEntity
extends PlantCloserEntity {
    private static final DataParameter<Boolean> MINE_READY = EntityDataManager.func_187226_a(PotatoMineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public boolean sign_red = true;
    private final float bombRange = 1.5f;

    public PotatoMineEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MINE_READY, (Object)false);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (this.getAttackTime() % this.getSignChangeTime() == 0) {
            this.sign_red = !this.sign_red;
        }
        this.setAttackTime(this.getAttackTime() + 1);
        if (this.getAttackTime() >= this.getReadyTime() && !this.isMineReady()) {
            this.outDirt();
        }
        if (this.isPlantInSuperMode() && !this.isMineReady()) {
            this.outDirt();
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.shootPotatos();
    }

    protected void shootPotatos() {
        int num = this.getShootNum();
        for (int i = 1; i <= num; ++i) {
            PotatoEntity potato = new PotatoEntity(this.field_70170_p, (LivingEntity)this);
            potato.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            float dx = (this.func_70681_au().nextFloat() - 0.5f) * (float)i / 3.0f;
            float dy = 1.0f;
            float dz = (this.func_70681_au().nextFloat() - 0.5f) * (float)i / 3.0f;
            potato.shoot(dx, dy, dz);
            this.field_70170_p.func_217376_c((Entity)potato);
        }
    }

    public int getShootNum() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    @Override
    public void performAttack(LivingEntity target1) {
        if (!this.isMineReady()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, 1.5, 1.5);
            EntityUtil.getAttackEntities((Entity)this, aabb).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage()));
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POTATO_MINE.get());
            for (int i = 1; i <= 5; ++i) {
                EntityUtil.spawnParticle((Entity)this, 3);
                EntityUtil.spawnParticle((Entity)this, 4);
            }
            this.func_70106_y();
        }
    }

    protected void outDirt() {
        this.setMineReady(true);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                Random rand = this.func_70681_au();
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.DIRT_BURST_OUT.get(), this.func_226277_ct_() + 0.5, this.func_226278_cu_(), this.func_226281_cx_() + 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.DIRT_BURST_OUT.get(), this.func_226277_ct_() + 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.DIRT_BURST_OUT.get(), this.func_226277_ct_() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() + 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.DIRT_BURST_OUT.get(), this.func_226277_ct_() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.5, ((double)rand.nextFloat() - 0.5) / 10.0, 0.05, ((double)rand.nextFloat() - 0.5) / 10.0);
            }
        } else {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DIRT_RISE.get());
        }
    }

    @Override
    protected boolean canBeImmuneToEnforce() {
        return this.isMineReady();
    }

    public int getReadyTime() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 2;
            return 240 - now * 10;
        }
        return 150;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 135 + 5 * lvl;
        }
        return 240.0f;
    }

    protected int getSignChangeTime() {
        if (this.isMineReady()) {
            return 10;
        }
        return 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.6f, 0.4f, false);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("mine_ready")) {
            this.setMineReady(compound.func_74767_n("mine_ready"));
        }
        if (compound.func_74764_b("sign_red")) {
            this.sign_red = compound.func_74767_n("sign_red");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("mine_ready", this.isMineReady());
        compound.func_74757_a("sign_red", this.sign_red);
    }

    public void setMineReady(boolean is) {
        this.field_70180_af.func_187227_b(MINE_READY, (Object)is);
    }

    public boolean isMineReady() {
        return (Boolean)this.field_70180_af.func_187225_a(MINE_READY);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.POTATO_MINE;
    }
}

