/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.flame;

import com.hungteen.pvz.entity.misc.ElementBallEntity;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.entity.zombie.zombotany.JalapenoZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JalapenoEntity
extends PlantBomberEntity {
    public JalapenoEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb() {
        int range = this.getFireRange();
        for (int i = -range; i <= range; ++i) {
            JalapenoEntity.clearSnowAndSpawnFlame((LivingEntity)this, i, 0);
            JalapenoEntity.clearSnowAndSpawnFlame((LivingEntity)this, 0, i);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JALAPENO.get());
        }
        JalapenoEntity.fireMob((LivingEntity)this, range, 0.5f);
        JalapenoEntity.fireMob((LivingEntity)this, 0.5f, range);
        if (!this.isCharmed()) {
            JalapenoEntity.killIceBall((LivingEntity)this);
        }
    }

    public static void killIceBall(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            float range = 10.0f;
            if (entity instanceof JalapenoEntity) {
                range = (float)((JalapenoEntity)entity).getFireRange() + 10.0f;
            } else if (entity instanceof JalapenoZombieEntity) {
                range = ((JalapenoZombieEntity)entity).getFireRange();
            }
            entity.field_70170_p.func_175647_a(ElementBallEntity.class, EntityUtil.getEntityAABB((Entity)entity, range, range), target -> target.getElementBallType() == ElementBallEntity.ElementTypes.ICE).forEach(target -> target.onKilledByPlants(entity));
        }
    }

    public static void fireMob(LivingEntity entity, float dx, float dz) {
        BlockPos pos = entity.func_233580_cy_();
        double x = (float)pos.func_177958_n() + 0.5f;
        double y = (float)pos.func_177956_o() + 0.5f;
        double z = (float)pos.func_177952_p() + 0.5f;
        AxisAlignedBB aabb = new AxisAlignedBB(x + (double)dx, y + 1.0, z + (double)dz, x - (double)dx, y - 1.0, z - (double)dz);
        for (LivingEntity target : EntityUtil.getEntityTargetableEntity((Entity)entity, aabb)) {
            float damage = 0.0f;
            if (entity instanceof JalapenoEntity) {
                damage = ((JalapenoEntity)entity).getAttackDamage();
            } else if (entity instanceof JalapenoZombieEntity) {
                damage = EntityUtil.getCurrentMaxHealth(target) * 2.0f;
            }
            target.func_70097_a((DamageSource)PVZDamageSource.causeFireDamage((Entity)entity, (Entity)entity), damage);
        }
    }

    public static void clearSnowAndSpawnFlame(LivingEntity entity, int dx, int dz) {
        BlockPos pos = entity.func_233580_cy_().func_177982_a(dx, 0, dz);
        if (entity.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE || entity.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_196604_cC) {
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        if (entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, ((double)entity.func_70681_au().nextFloat() - 0.5) / 10.0, (double)(entity.func_70681_au().nextFloat() / 8.0f), ((double)entity.func_70681_au().nextFloat() - 0.5) / 10.0);
            }
        }
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 139.5f + 0.5f * (float)lvl;
        }
        return 150.0f;
    }

    public int getFireRange() {
        if (this.isPlantInStage(1)) {
            return 10;
        }
        if (this.isPlantInStage(2)) {
            return 15;
        }
        return 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.5f);
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.JALAPENO;
    }
}

