/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.ice;

import com.hungteen.pvz.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.entity.misc.ElementBallEntity;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.entity.plant.interfaces.IIcePlant;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class IceShroomEntity
extends PlantBomberEntity
implements IIcePlant {
    public IceShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb() {
        if (!this.field_70170_p.field_72995_K) {
            float len = this.getAttackRange();
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, len, len);
            int cnt = 0;
            for (LivingEntity entity : EntityUtil.getEntityTargetableEntity((Entity)this, aabb)) {
                PVZDamageSource source = PVZDamageSource.causeIceDamage((Entity)this, (Entity)this);
                source.addEffect(this.getColdEffect());
                source.addEffect(this.getFrozenEffect());
                entity.func_70097_a((DamageSource)source, this.getAttackDamage());
                if (!EntityUtil.isEntityCold(entity)) continue;
                ++cnt;
            }
            PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (player != null && player instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this, cnt);
            }
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.ZOMBIE_FROZEN.get());
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 15; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.SNOW_FLOWER.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)((this.func_70681_au().nextFloat() - 0.5f) / 4.0f), (double)(this.func_70681_au().nextFloat() / 5.0f), (double)((this.func_70681_au().nextFloat() - 0.5f) / 4.0f));
            }
        }
        this.killFireBall();
    }

    private void killFireBall() {
        if (!this.field_70170_p.field_72995_K) {
            float range = this.getAttackRange() + 10.0f;
            this.field_70170_p.func_175647_a(ElementBallEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), target -> target.getElementBallType() == ElementBallEntity.ElementTypes.FLAME).forEach(target -> target.onKilledByPlants((LivingEntity)this));
        }
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 0.5f * (float)lvl;
        }
        return 10.0f;
    }

    public float getAttackRange() {
        if (this.isPlantInStage(1)) {
            return 10.0f;
        }
        if (this.isPlantInStage(2)) {
            return 15.0f;
        }
        return 20.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.85f, (float)1.35f);
    }

    @Override
    public EffectInstance getColdEffect() {
        int lvl = this.getPlantLvl();
        int amount = 0;
        if (lvl > 4 && lvl <= 20) {
            amount = lvl <= 8 ? 5 : (lvl <= 16 ? 6 : 7);
        }
        return new EffectInstance((Effect)EffectRegister.COLD_EFFECT.get(), this.getColdTick() + this.getFrozenTick(), amount, false, false);
    }

    public int getColdLvl() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 3 + now;
        }
        return 7;
    }

    public int getColdTick() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 5 * lvl;
        }
        return 100;
    }

    public int getFrozenTick() {
        int lvl = this.getPlantLvl();
        int time = 240;
        if (lvl <= 20) {
            time = 93 + 7 * lvl;
        }
        return time;
    }

    @Override
    public EffectInstance getFrozenEffect() {
        return new EffectInstance((Effect)EffectRegister.FROZEN_EFFECT.get(), this.getFrozenTick(), 1, false, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ICE_SHROOM;
    }
}

