/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.magic;

import com.hungteen.pvz.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class CoffeeBeanEntity
extends PlantBomberEntity {
    public CoffeeBeanEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
        this.isImmuneToWeak = true;
    }

    @Override
    public void startBomb() {
        if (!this.field_70170_p.field_72995_K) {
            float len = this.getAwakeRange();
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, len, len + 2.0f);
            boolean hasEffect = false;
            int awakeCnt = 0;
            for (PVZPlantEntity plant : this.field_70170_p.func_217357_a(PVZPlantEntity.class, aabb)) {
                if (EntityUtil.checkCanEntityAttack((Entity)this, (Entity)plant)) continue;
                if (plant.isPlantSleeping()) {
                    ++awakeCnt;
                }
                plant.setSleepTime(-this.getAwakeTime());
                hasEffect = true;
            }
            PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (player != null && player instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this, awakeCnt);
            }
            if (hasEffect) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.WAKE_UP.get());
            }
        }
    }

    public float getAwakeRange() {
        return this.getPlantLvl() <= 10 ? 1.5f : 2.5f;
    }

    public int getAwakeTime() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 22800 + 1200 * lvl;
        }
        return 48000;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)0.8f);
    }

    public boolean func_189652_ae() {
        return true;
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.COFFEE_BEAN;
    }
}

