/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.spear;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.ThornEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class CactusEntity
extends PlantShooterEntity {
    private static final DataParameter<Float> CACTUS_HEIGHT = EntityDataManager.func_187226_a(CactusEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(CactusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final float MAX_SEGMENT_NUM = 4.0f;
    public static final float SEGMENT_HEIGHT = 0.54f;
    private static final float MIN_SHOOT_HEIGHT = 1.25f;
    private static final float MAX_SHOOT_HEIGHT = 3.41f;
    protected final double LENTH = 0.3;

    public CactusEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CACTUS_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 6.0f, 0.0f));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target = this.func_70638_az();
            if (target != null) {
                if (!this.isSuitableHeight((Entity)target)) {
                    float dh = 0.54f;
                    if (this.func_226278_cu_() < target.func_226278_cu_()) {
                        this.setCactusHeight(Math.min(this.getCactusHeight() + 0.54f, 2.16f));
                    } else {
                        this.setCactusHeight(Math.max(this.getCactusHeight() - 0.54f, 0.0f));
                    }
                }
            } else {
                this.setCactusHeight(0.0f);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        this.dealThornBackDamage(source);
        return super.func_70097_a(source, amount);
    }

    private void dealThornBackDamage(DamageSource source) {
        if (EntityUtil.checkCanEntityAttack((Entity)this, source.func_76364_f())) {
            float damage = this.getThornDamage();
            if (this.isCactusPowered()) {
                damage *= 2.0f;
            }
            source.func_76364_f().func_70097_a((DamageSource)PVZDamageSource.causeThornDamage((Entity)this, (Entity)this), damage);
        }
    }

    public int getThornCount() {
        if (this.isPlantInStage(1)) {
            return 2;
        }
        if (this.isPlantInStage(2)) {
            return 3;
        }
        return 4;
    }

    public float getThornDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 1.75f + 0.25f * (float)lvl;
        }
        return 6.5f;
    }

    public float getShootHeight() {
        return this.getCactusHeight() + 1.25f;
    }

    private boolean isSuitableHeight(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double ly = target.func_226278_cu_() - this.func_226278_cu_() - (double)this.getShootHeight();
        double ry = ly + (double)target.func_213302_cg();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return ly <= y && ry >= -y;
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    public boolean checkY(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return this.func_226278_cu_() + (double)3.41f + y >= target.func_226278_cu_() && this.func_226278_cu_() + 1.25 - y <= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)(2.0f + this.getCactusHeight()));
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setCactusPowered(true);
    }

    @Override
    public boolean canStartSuperMode() {
        return !this.isCactusPowered();
    }

    @Override
    public void shootBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double y = this.func_226278_cu_() + (double)this.getShootHeight();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double tmp = this.LENTH / dis;
        double deltaX = tmp * dx;
        double deltaZ = tmp * dz;
        ThornEntity thorn = new ThornEntity(this.field_70170_p, (LivingEntity)this);
        thorn.setThornType(ThornEntity.ThornTypes.NORMAL);
        thorn.setThornState(this.isCactusPowered() ? ThornEntity.ThornStates.POWER : ThornEntity.ThornStates.NORMAL);
        thorn.setExtraHitCount(this.isCactusPowered() ? this.getThornCount() : 1);
        thorn.func_70107_b(this.func_226277_ct_() + deltaX, y, this.func_226281_cx_() + deltaZ);
        thorn.shootPea(dx, target.func_226278_cu_() + (double)target.func_70047_e() - y, dz, this.getBulletSpeed());
        this.field_70170_p.func_217376_c((Entity)thorn);
    }

    @Override
    public float getBulletSpeed() {
        return 1.2f;
    }

    @Override
    public int getShootCD() {
        return this.getNormalAttackCD();
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 2;
            return 2.25f + (float)now * 0.25f;
        }
        return 4.5f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("cactus_powered")) {
            this.setCactusPowered(compound.func_74767_n("cactus_powered"));
        }
        if (compound.func_74764_b("cactus_height")) {
            this.setCactusHeight(compound.func_74760_g("cactus_height"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("cactus_powered", this.isCactusPowered());
        compound.func_74776_a("cactus_height", this.getCactusHeight());
    }

    public float getCactusHeight() {
        return ((Float)this.field_70180_af.func_187225_a(CACTUS_HEIGHT)).floatValue();
    }

    public void setCactusHeight(float h) {
        this.field_70180_af.func_187227_b(CACTUS_HEIGHT, (Object)Float.valueOf(h));
    }

    public boolean isCactusPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setCactusPowered(boolean is) {
        this.field_70180_af.func_187227_b(POWERED, (Object)is);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CACTUS;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }
}

