/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.spear;

import com.hungteen.pvz.entity.ai.target.PVZGlobalTargetGoal;
import com.hungteen.pvz.entity.bullet.ThornEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.HashSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CatTailEntity
extends PlantShooterEntity {
    public HashSet<ThornEntity> thorns = new HashSet();
    private int powerCount = 0;
    private int powerTick = 0;
    private final int POWER_CD = 200;

    public CatTailEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZGlobalTargetGoal((MobEntity)this, true, this.getShootRange(), this.getShootRange()));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.powerTick > 0) {
                --this.powerTick;
            }
            HashSet tmp = new HashSet();
            this.thorns.forEach(thorn -> {
                if (!thorn.field_70128_L && thorn.isInControl()) {
                    thorn.setThornTarget(this.func_70638_az());
                    tmp.add(thorn);
                }
            });
            this.thorns.clear();
            this.thorns = tmp;
        }
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.powerCount += this.getPowerThornCount();
    }

    @Override
    public int getShootCD() {
        return this.getNormalAttackCD();
    }

    @Override
    public boolean checkY(Entity target) {
        return true;
    }

    @Override
    public void shootBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        ThornEntity thorn = new ThornEntity(this.field_70170_p, (LivingEntity)this);
        thorn.setThornType(this.getThornShootType());
        thorn.setThornState(thorn.getThornType() == ThornEntity.ThornTypes.AUTO ? ThornEntity.ThornStates.POWER : ThornEntity.ThornStates.NORMAL);
        thorn.setExtraHitCount(this.getExtraAttackCount());
        thorn.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() + (double)0.2f, this.func_226281_cx_());
        this.thorns.add(thorn);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        this.field_70170_p.func_217376_c((Entity)thorn);
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 2;
            return 2.25f + (float)now * 0.25f;
        }
        return 4.5f;
    }

    public int getExtraAttackCount() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return now + 1;
        }
        return 5;
    }

    private ThornEntity.ThornTypes getThornShootType() {
        if (this.powerCount > 0 && this.powerTick == 0) {
            this.powerTick = this.POWER_CD;
            --this.powerCount;
            return ThornEntity.ThornTypes.AUTO;
        }
        return ThornEntity.ThornTypes.GUILD;
    }

    public int getPowerThornCount() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() > 0 && this.getAttackTime() % this.getAnimCD() == 0;
    }

    public int getAnimCD() {
        return 8;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(this.getAnimCD() * 2);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.4f);
    }

    @Override
    public float getShootRange() {
        return 50.0f;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CAT_TAIL;
    }

    @Override
    public int getSuperTimeLength() {
        return 40;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("power_thorn_count")) {
            this.powerCount = compound.func_74762_e("power_thorn_count");
        }
        if (compound.func_74764_b("power_shoot_tick")) {
            this.powerTick = compound.func_74762_e("power_shoot_tick");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("power_thorn_count", this.powerCount);
        compound.func_74768_a("power_shoot_tick", this.powerTick);
    }
}

