/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.spear;

import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.poolday.BobsleTeamEntity;
import com.hungteen.pvz.entity.zombie.poolday.ZomboniEntity;
import com.hungteen.pvz.entity.zombie.roof.CatapultZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.misc.damage.PVZDamageType;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class SpikeRockEntity
extends PVZPlantEntity {
    private static final DataParameter<Integer> SPIKE_NUM = EntityDataManager.func_187226_a(SpikeRockEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public SpikeRockEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.setSpikeNum(this.getSpikesCount());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIKE_NUM, (Object)1);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSpikeNum() < 0) {
                this.func_70106_y();
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.isPlantInSuperMode() && this.getSuperTime() % 10 == 0) {
                for (LivingEntity target : EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, 10.0, 2.0))) {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeSpikeDamage((Entity)this, (Entity)this), this.getAttackDamage() * 2.0f);
                    for (int i = 0; i < 4; ++i) {
                        EntityUtil.spawnParticle((Entity)target, 6);
                    }
                }
            }
        }
    }

    @Override
    protected void func_85033_bc() {
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int l;
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (l = 0; l < list.size(); ++l) {
                LivingEntity target = (LivingEntity)list.get(l);
                if (target == this || !this.shouldCollideWithEntity(target)) continue;
                this.func_82167_n((Entity)target);
            }
            if (!this.field_70170_p.field_72995_K && this.getAttackTime() == 0) {
                for (l = 0; l < list.size(); ++l) {
                    LivingEntity target = (LivingEntity)list.get(l);
                    if (target == this || this.getSpikeNum() < 0 || !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target)) continue;
                    this.spikeNormalAttack(target);
                }
            }
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target)) {
            return false;
        }
        return super.shouldCollideWithEntity(target);
    }

    protected void spikeNormalAttack(LivingEntity target) {
        if (!this.canPlantNormalUpdate()) {
            return;
        }
        this.setAttackTime(this.getAttackCD());
        if (target instanceof ZomboniEntity || target instanceof BobsleTeamEntity || target instanceof CatapultZombieEntity) {
            target.func_70097_a((DamageSource)PVZDamageSource.causeSpikeDamage((Entity)this, (Entity)this), target.func_110138_aP());
            this.setSpikeNum(this.getSpikeNum() - 1);
        } else {
            target.func_70097_a((DamageSource)PVZDamageSource.causeSpikeDamage((Entity)this, (Entity)this), this.getAttackDamage());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.CRUSH && this.getSpikeNum() >= 0) {
            this.setSpikeNum(this.getSpikeNum() - 1);
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public int getAttackCD() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 41 - lvl;
        }
        return 20;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 16) {
            int now = (lvl - 1) / 2;
            return 3.75f + 0.25f * (float)now;
        }
        return 6.0f;
    }

    public int getSpikesCount() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 5;
            return 3 * now + 6;
        }
        return 15;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.95f, 0.4f, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SPIKE_ROCK;
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 100;
        }
        if (this.isPlantInStage(2)) {
            return 150;
        }
        return 200;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("spike_num")) {
            this.setSpikeNum(compound.func_74762_e("spike_num"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("spike_num", this.getSpikeNum());
    }

    public int getSpikeNum() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_NUM);
    }

    public void setSpikeNum(int num) {
        this.field_70180_af.func_187227_b(SPIKE_NUM, (Object)num);
    }
}

