/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.toxic;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.FumeEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FumeShroomEntity
extends PlantShooterEntity {
    protected final double LENTH = 0.2;

    public FumeShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 2.0f, 0.0f));
    }

    @Override
    public void shootBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double y = this.func_226278_cu_() + (double)(this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.7f);
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double tmp = this.LENTH / dis;
        double deltaX = tmp * dx;
        double deltaZ = tmp * dz;
        FumeEntity fume = new FumeEntity(this.field_70170_p, (LivingEntity)this);
        if (this.isPlantInSuperMode()) {
            fume.setKnockback(this.getKnockback());
        }
        fume.func_70107_b(this.func_226277_ct_() + deltaX, y, this.func_226281_cx_() + deltaZ);
        fume.shootPea(dx, target.func_226278_cu_() + (double)target.func_213302_cg() - y, dz, this.getBulletSpeed());
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.FUME.get());
        this.field_70170_p.func_217376_c((Entity)fume);
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 40;
        }
        if (this.isPlantInStage(2)) {
            return 50;
        }
        return 60;
    }

    public int getKnockback() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.25f);
    }

    @Override
    public float getShootRange() {
        return 20.0f;
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.GLOOM_SHROOM;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.FUME_SHROOM;
    }
}

