/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.toxic;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.FumeEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class GloomShroomEntity
extends PlantShooterEntity {
    protected final double LENTH = 0.2;
    private static final int SHOOT_NUM = 8;

    public GloomShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 2.0f, 0.0f));
    }

    @Override
    public void shootBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        float now = this.field_70759_as;
        boolean kb = this.func_70681_au().nextInt(400) < this.getKBChance();
        for (int i = 0; i < 8; ++i) {
            this.shootFume(now, kb);
            now += 45.0f;
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.FUME.get());
    }

    private void shootFume(float angle, boolean kb) {
        double vx = -MathHelper.func_76126_a((float)(angle *= 0.01745328f));
        double vz = MathHelper.func_76134_b((float)angle);
        FumeEntity fume = new FumeEntity(this.field_70170_p, (LivingEntity)this);
        if (this.isPlantInSuperMode()) {
            fume.setKnockback(this.getKnockback());
        } else if (kb) {
            fume.setKnockback(1);
        }
        fume.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e() - 0.2, this.func_226281_cx_());
        fume.func_213317_d(new Vector3d(vx, 0.0, vz));
        this.field_70170_p.func_217376_c((Entity)fume);
    }

    public int getKnockback() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    public int getKBChance() {
        return this.getPlantLvl();
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public int getSuperTimeLength() {
        return 100;
    }

    @Override
    public int getNormalAttackCD() {
        return 8;
    }

    @Override
    public float getShootRange() {
        return 4.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.8f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GLOOM_SHROOM;
    }
}

