/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassnight;

import com.hungteen.pvz.entity.zombie.base.UnderGroundZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.DancingZombieEntity;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class BackupDancerEntity
extends UnderGroundZombieEntity {
    public static final int DANCE_CD = 100;
    private int ownerId;
    private final int minWalkCD = 60;
    private final int maxWalkCD = 300;
    private int walkCD = 0;

    public BackupDancerEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getAttackTime() > 0 ? 0.0 : (double)0.19f);
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (this.getAttackTime() < 0) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.needFollow()) {
                this.setAttackTime(this.getDancerOwner().getAttackTime());
                this.field_70177_z = this.getDancerOwner().field_70177_z;
                this.field_70125_A = this.getDancerOwner().field_70125_A;
                this.field_70759_as = this.getDancerOwner().field_70759_as;
            } else if (this.getAttackTime() == 0) {
                if (this.walkCD == 0 && this.func_70681_au().nextFloat() < 0.05f) {
                    this.setAttackTime(100);
                    this.walkCD = this.func_70681_au().nextInt(this.maxWalkCD - this.minWalkCD + 1) + this.minWalkCD;
                } else if (this.walkCD > 0) {
                    --this.walkCD;
                }
            } else if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
        }
    }

    @Override
    public float getLife() {
        return 20.0f;
    }

    public boolean needFollow() {
        return this.getDancerOwner() != null && this.getDancerOwner().func_70089_S();
    }

    public void setOwnerId(int id) {
        this.ownerId = id;
    }

    public DancingZombieEntity getDancerOwner() {
        Entity entity = this.field_70170_p.func_73045_a(this.ownerId);
        if (entity instanceof DancingZombieEntity) {
            return (DancingZombieEntity)entity;
        }
        return null;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("dancer_owner_id")) {
            this.ownerId = compound.func_74762_e("dancer_owner_id");
        }
        if (compound.func_74764_b("zombie_walk_cd")) {
            this.walkCD = compound.func_74762_e("zombie_walk_cd");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("dancer_owner_id", this.ownerId);
        compound.func_74768_a("zombie_walk_cd", this.walkCD);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BACKUP_DANCER;
    }
}

