/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassnight;

import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.base.UnderGroundZombieEntity;
import com.hungteen.pvz.entity.zombie.other.NobleZombieEntity;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.others.WeightList;
import java.util.Random;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TombStoneEntity
extends UnderGroundZombieEntity {
    public static final Zombies[] GROUND_ZOMBIES = new Zombies[]{Zombies.NORMAL_ZOMBIE, Zombies.CONEHEAD_ZOMBIE, Zombies.BUCKETHEAD_ZOMBIE};
    private int currentSummonCD = this.func_70681_au().nextInt(this.maxSummonCD - this.minSummonCD + 1) + this.minSummonCD;
    private int minSummonCD = 360;
    private int maxSummonCD = 1200;

    public TombStoneEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeButter = false;
        this.canBeCold = false;
        this.canBeCharm = false;
        this.canBeMini = false;
        this.canBeFrozen = false;
        this.canBeStealByBungee = false;
        this.canCollideWithZombie = false;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, NobleZombieEntity.class, true));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() >= 0 && this.canSummonZombie()) {
            this.setAttackTime(this.getAttackTime() + 1);
            if (this.getAttackTime() >= this.currentSummonCD) {
                this.summonZombie();
                this.setAttackTime(0);
                this.currentSummonCD = this.func_70681_au().nextInt(this.maxSummonCD - this.minSummonCD + 1) + this.minSummonCD;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos = this.func_233580_cy_();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, this.func_226278_cu_(), (double)pos.func_177952_p() + 0.5);
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return target instanceof TombStoneEntity;
    }

    public void summonZombie() {
        int pos = this.func_70681_au().nextInt(GROUND_ZOMBIES.length);
        PVZZombieEntity zombie = ZombieUtil.getZombieEntity(this.field_70170_p, GROUND_ZOMBIES[pos]);
        if (zombie != null) {
            if (zombie instanceof UnderGroundZombieEntity) {
                ((UnderGroundZombieEntity)zombie).setRiseType(true);
            }
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_233580_cy_());
        }
    }

    protected boolean canSummonZombie() {
        return this.func_70638_az() != null;
    }

    public static boolean canTombSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return worldIn instanceof ServerWorld && !((ServerWorld)worldIn).func_72935_r() ? TombStoneEntity.canZombieSpawn(zombieType, worldIn, reason, pos, rand) : false;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.func_184188_bt().isEmpty() && stack.func_77973_b() instanceof PlantCardItem) {
                PlantCardItem cardItem = (PlantCardItem)stack.func_77973_b();
                if (cardItem.plantType == Plants.GRAVE_BUSTER) {
                    PlantCardItem.checkSunAndSummonPlant(player, stack, cardItem, this.func_233580_cy_(), plantEntity -> plantEntity.func_70624_b((LivingEntity)this));
                } else if (cardItem instanceof ImitaterCardItem && ((ImitaterCardItem)cardItem).isPlantTypeEqual(stack, Plants.GRAVE_BUSTER)) {
                    ImitaterCardItem.checkSunAndSummonImitater(player, stack, cardItem, this.func_233580_cy_(), imitater -> imitater.func_70624_b((LivingEntity)this));
                }
                return ActionResultType.CONSUME;
            }
        }
        return super.func_184199_a(player, vec3d, hand);
    }

    @Override
    protected WeightList<PVZZombieEntity.DropType> getDropSpecialList() {
        return super.getDropSpecialList().setLeftItem(PVZZombieEntity.DropType.COPPER);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.6f);
    }

    @Override
    public float getLife() {
        return 70.0f;
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.TOMB_STONE;
    }
}

