/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.other;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.misc.ZombieHandEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.other.MournerZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class NobleZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Integer> TP_TICK = EntityDataManager.func_187226_a(NobleZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.NOTCHED_6).func_186741_a(true);
    private int summonTick;
    private final int minSummonTick = 300;
    private final int maxSummonTick = 600;
    private final int maxSummonedCnt = 8;
    private final int minTpCD = 400;
    private final int maxTpCD = 800;
    private final int minSleepAttackCD = 360;
    private final int maxSleepAttackCD = 1000;

    public NobleZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAttackTime(this.maxSleepAttackCD);
        this.summonTick = this.func_70681_au().nextInt(this.maxSummonTick - this.minSummonTick) + this.minSummonTick;
        this.setTpTick(-this.func_70681_au().nextInt(this.maxTpCD - this.minTpCD + 1) - this.minTpCD);
        this.field_70728_aV = 1000;
        this.canBeButter = false;
        this.canBeCold = false;
        this.canBeCharm = false;
        this.canBeMini = false;
        this.canBeStealByBungee = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TP_TICK, (Object)0);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.16f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(20.0);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            for (Entity target : EntityUtil.getEntityAttackableTarget((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0))) {
                if (this.func_70681_au().nextInt(4) != 0) continue;
                ZombieHandEntity hand = (ZombieHandEntity)((EntityType)EntityRegister.ZOMBIE_HAND.get()).func_200721_a(this.field_70170_p);
                hand.setOwner((LivingEntity)this);
                EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, hand, target.func_233580_cy_());
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        this.bossInfo.func_186735_a(percent);
        if (!this.canZombieNormalUpdate()) {
            this.setTpTick(-this.maxTpCD);
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.summonTick > 0) {
                --this.summonTick;
            } else if (this.summonTick == 0) {
                this.summonTick = this.func_70681_au().nextInt(this.maxSummonTick - this.minSummonTick + 1) + this.minSummonTick;
                this.checkAndSummonMournerZombie();
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            } else {
                this.checkAndSleepPlant();
            }
        } else if (this.getAttackTime() < 20) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        this.checkAndHeal();
        if (this.getTpTick() < 0) {
            this.setTpTick(this.getTpTick() + 1);
        } else if (this.getTpTick() == 0) {
            if (this.func_70681_au().nextInt(5) == 0) {
                this.setTpTick(1);
            }
        } else {
            if (this.getTpTick() >= this.getTpCD()) {
                this.checkAndTeleport();
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 9; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (double)(this.func_70681_au().nextInt(5) - 2), this.func_226278_cu_() + (double)this.func_70681_au().nextInt(3), this.func_226281_cx_() + (double)(this.func_70681_au().nextInt(5) - 2), 0.0, 0.0, 0.0);
                }
            }
            this.setTpTick(this.getTpTick() + 1);
        }
    }

    private void checkAndTeleport() {
        if (this.func_70638_az() == null) {
            return;
        }
        BlockPos teleportPos = this.func_70638_az().func_233580_cy_();
        this.setTpTick(-this.func_70681_au().nextInt(this.maxTpCD - this.minTpCD + 1) - this.minTpCD);
        float range = this.getExpRange();
        this.teleportToPos(teleportPos.func_177958_n(), teleportPos.func_177956_o(), teleportPos.func_177952_p());
        for (Entity target : EntityUtil.getEntityAttackableTarget((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range))) {
            if (!(target instanceof PVZPlantEntity)) continue;
            target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), ((LivingEntity)target).func_110138_aP());
        }
    }

    private void checkAndSummonMournerZombie() {
        int num = this.field_70170_p.func_217394_a((EntityType)EntityRegister.MOURNER_ZOMBIE.get(), EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0), zombie -> !zombie.isCharmed()).size();
        if (num >= this.maxSummonedCnt) {
            this.checkAndSummonZombieHand();
            return;
        }
        int max = Math.min(this.maxSummonedCnt - num, 3);
        int min = 1;
        int cnt = this.func_70681_au().nextInt(max - min + 1) + min;
        for (int i = 0; i < cnt; ++i) {
            MournerZombieEntity zombie2 = (MournerZombieEntity)((EntityType)EntityRegister.MOURNER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            BlockPos pos = this.func_70638_az() == null ? this.func_233580_cy_() : this.func_70638_az().func_233580_cy_();
            for (int chance = 0; chance < 30; ++chance) {
                int x = this.func_233580_cy_().func_177958_n() + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)5, (int)20) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int y = this.func_233580_cy_().func_177956_o() + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)10);
                int z = this.func_233580_cy_().func_177952_p() + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)5, (int)20) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                BlockPos tmp = new BlockPos(x, y, z);
                zombie2.func_70107_b(x, y, z);
                if (!this.field_70170_p.func_180495_p(tmp).func_215682_a((IBlockReader)this.field_70170_p, tmp, (Entity)zombie2, Direction.UP) || !this.field_70170_p.func_226668_i_((Entity)zombie2) || !this.field_70170_p.func_226669_j_((Entity)zombie2)) continue;
                pos = tmp;
                break;
            }
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie2, pos);
        }
    }

    private void checkAndSleepPlant() {
        List list = this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0), plant -> !plant.isCharmed());
        int len = list.size();
        if (len == 0) {
            this.setAttackTime(this.func_70681_au().nextInt(this.maxSleepAttackCD - this.minSleepAttackCD + 1) + this.minSleepAttackCD);
            return;
        }
        int pos = this.func_70681_au().nextInt(len);
        PVZPlantEntity plant2 = (PVZPlantEntity)list.get(pos);
        float range = 1.5f;
        for (PVZPlantEntity target : this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)plant2, 1.5, 1.5), p -> !p.isCharmed())) {
            target.setSleepTime(2400);
        }
        this.setAttackTime(this.func_70681_au().nextInt(this.maxSleepAttackCD - this.minSleepAttackCD + 1) + this.minSleepAttackCD);
    }

    private void checkAndSummonZombieHand() {
        int cnt = this.getHandSummonNum();
        List<LivingEntity> list = EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0));
        for (int i = 0; i < list.size(); ++i) {
            if (i + cnt < list.size() && this.func_70681_au().nextInt(5) != 0) continue;
            ZombieHandEntity hand = (ZombieHandEntity)((EntityType)EntityRegister.ZOMBIE_HAND.get()).func_200721_a(this.field_70170_p);
            hand.setOwner((LivingEntity)this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, hand, list.get(i).func_233580_cy_());
            if (--cnt == 0) break;
        }
    }

    private void checkAndHeal() {
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                this.func_70691_i(0.3f);
            } else if (percent < 0.5f) {
                this.func_70691_i(0.2f);
            } else if (percent < 0.16666667f) {
                this.func_70691_i(0.5f);
            }
        }
    }

    public void teleportToPos(double x, double y, double z) {
        boolean flag2;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        if (flag && (flag2 = this.func_213373_a(x, y, z, true))) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        amount = amount >= 10.0f ? (amount /= 3.0f) : (amount /= 2.0f);
        return super.func_70097_a(source, amount);
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.9f);
    }

    protected int getTpCD() {
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        if (percent < 0.33333334f) {
            return 60;
        }
        if (percent < 0.6666667f) {
            return 80;
        }
        return 100;
    }

    protected float getExpRange() {
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        if (percent < 0.5f) {
            return 2.5f;
        }
        return 1.5f;
    }

    protected int getHandSummonNum() {
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        if (percent < 0.33333334f) {
            return 3;
        }
        if (percent < 0.6666667f) {
            return 2;
        }
        return 1;
    }

    @Override
    protected PVZZombieEntity.Type getSpawnType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    public boolean canZombieBeRemoved() {
        return false;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("summon_zombie_tick")) {
            this.summonTick = compound.func_74762_e("summon_zombie_tick");
        }
        if (compound.func_74764_b("zombie_tp_tick")) {
            this.setTpTick(compound.func_74762_e("zombie_tp_tick"));
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("summon_zombie_tick", this.summonTick);
        compound.func_74768_a("zombie_tp_tick", this.getTpTick());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public int getTpTick() {
        return (Integer)this.field_70180_af.func_187225_a(TP_TICK);
    }

    public void setTpTick(int tick) {
        this.field_70180_af.func_187227_b(TP_TICK, (Object)tick);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.NOBLE_ZOMBIE;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.NOBLE_ZOMBIE;
    }
}

