/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.other;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class TrickZombieEntity
extends PVZZombieEntity {
    public static final int EXPLOSION_CHANCE = 8;
    public static final int SUMMON_CHACNE = 5;
    private int lastSummonTick = 0;
    private final int summonGap = 40;

    public TrickZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.22f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount >= 2.0f && !this.field_70170_p.field_72995_K && this.field_70173_aa - this.lastSummonTick >= this.summonGap && this.func_70681_au().nextInt(5) == 0) {
            this.lastSummonTick = this.field_70173_aa;
            TrickZombieEntity zombie = (TrickZombieEntity)((EntityType)EntityRegister.TRICK_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            BlockPos pos = this.func_233580_cy_().func_177982_a(this.func_70681_au().nextInt(5) - 2, this.func_70681_au().nextInt(2), this.func_70681_au().nextInt(5) - 2);
            if (this.isCharmed()) {
                zombie.setCharmed(true);
            }
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, pos);
        }
        return super.func_70097_a(source, amount);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec3d, Hand hand) {
        if (!this.field_70170_p.field_72995_K && player.func_184586_b(hand).func_77973_b() == ItemRegister.CANDY.get() && !this.isCharmed() && this.func_70681_au().nextInt(3) == 0) {
            player.func_184586_b(hand).func_190918_g(1);
            this.setCharmed(true);
            return ActionResultType.CONSUME;
        }
        return super.func_184199_a(player, vec3d, hand);
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        if (!this.func_70644_a((Effect)EffectRegister.COLD_EFFECT.get()) && !this.isCharmed() && this.func_70681_au().nextInt(8) == 0) {
            Explosion.Mode mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.5f, mode);
        }
        super.func_213345_d(damageSourceIn);
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.3f, (float)0.5f);
        }
        return EntitySize.func_220314_b((float)0.6f, (float)1.2f);
    }

    @Override
    public float getLife() {
        return 10.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.TRICK_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.TRICK_ZOMBIE;
    }
}

