/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolday;

import com.hungteen.pvz.entity.ai.BreakBlockGoal;
import com.hungteen.pvz.entity.ai.attack.ZombieMeleeAttackGoal;
import com.hungteen.pvz.entity.ai.target.ZombieNearestTargetGoal;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class DolphinRiderEntity
extends PVZZombieEntity {
    private static final float UP_SPEED = 0.05f;
    private static final int JUMP_CD = 200;
    private static final int JUMP_CHANCE = 10;
    private int jumpTick;

    public DolphinRiderEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.jumpTick = 100;
        this.canBeMini = false;
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.8f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(0, (Goal)new ZombieMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreakBlockGoal((Block)BlockRegister.LILY_PAD.get(), (CreatureEntity)this, 1.0, 3));
        this.field_70715_bh.func_75776_a(0, (Goal)new ZombieNearestTargetGoal((MobEntity)this, true, 80.0f, 60.0f));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.jumpTick > 0) {
                --this.jumpTick;
            }
            if (this.jumpTick == 0 && this.field_70146_Z.nextInt(10) == 0) {
                this.func_184185_a((SoundEvent)SoundRegister.DOLPHIN_JUMP.get(), 1.0f, 1.0f);
                double dxz = 2.0;
                double dyy = 0.5;
                this.func_213293_j(((double)this.field_70146_Z.nextFloat() - 0.5) / dxz, dyy, ((double)this.field_70146_Z.nextFloat() - 0.5) / dxz);
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
                this.jumpTick = this.field_70146_Z.nextInt(200) + 200;
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70090_H() && this.shouldUp()) {
            Vector3d v = this.func_213322_ci();
            this.func_213293_j(v.func_82615_a(), 0.05f, v.func_82616_c());
        }
    }

    protected boolean shouldUp() {
        return this.func_233571_b_((ITag)FluidTags.field_206959_a) > (double)(this.func_70047_e() / 3.0f);
    }

    @Override
    public boolean checkCanZombieTarget(LivingEntity target) {
        if (super.checkCanZombieTarget(target)) {
            return !this.func_70090_H() || target.func_70090_H();
        }
        return false;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.6f);
    }

    @Override
    protected float func_189749_co() {
        return 0.9f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    public float getLife() {
        return 60.0f;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.DOLPHIN_RIDER;
    }
}

