/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolnight;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.misc.damage.PVZDamageType;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class BalloonZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Boolean> HAS_BALLOON = EntityDataManager.func_187226_a(BalloonZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private PathNavigator FlyNavigator;
    private PathNavigator GroundNavigator;

    public BalloonZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.FlyNavigator = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        this.GroundNavigator = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 360, true);
        this.setBalloon(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BALLOON, (Object)true);
    }

    @Override
    protected void func_184651_r() {
        this.FlyNavigator = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        this.GroundNavigator = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
        super.func_184651_r();
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.18f);
        this.func_110148_a(Attributes.field_233822_e_).func_111128_a(0.5);
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76355_l() == DamageSource.field_76379_h.field_76373_n) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.THORN && this.hasBalloon()) {
            this.onBalloonExplode();
            amount = 0.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void onBalloonExplode() {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BALLOON_POP.get());
        }
        this.setBalloon(false);
        this.func_189654_d(false);
        this.field_70765_h = new MovementController((MobEntity)this);
    }

    public static boolean canBalloonSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        if (!BalloonZombieEntity.checkZombieSpawn(zombieType, worldIn, reason)) {
            return false;
        }
        return worldIn.func_226658_a_(LightType.BLOCK, pos) < 8 && worldIn.func_175659_aa() != Difficulty.PEACEFUL && (reason == SpawnReason.SPAWNER || worldIn.func_175623_d(pos));
    }

    @Override
    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundRegister.BALLOON_FULL.get();
    }

    @Override
    public float getLife() {
        return 22.0f;
    }

    @Override
    public boolean canBeButter() {
        return !this.hasBalloon();
    }

    @Override
    public boolean canBeFrozen() {
        return !this.hasBalloon();
    }

    public PathNavigator func_70661_as() {
        if (this.hasBalloon()) {
            if (!(this.field_70699_by instanceof FlyingPathNavigator)) {
                this.field_70699_by = this.FlyNavigator;
            }
        } else if (!(this.field_70699_by instanceof GroundPathNavigator)) {
            this.field_70699_by = this.GroundNavigator;
        }
        return super.func_70661_as();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("HAS_BALLOON")) {
            this.setBalloon(compound.func_74767_n("HAS_BALLOON"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HAS_BALLOON", this.hasBalloon());
    }

    public void setBalloon(boolean has) {
        this.field_70180_af.func_187227_b(HAS_BALLOON, (Object)has);
    }

    public boolean hasBalloon() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BALLOON);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BALLOON_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BALLOON_ZOMBIE;
    }
}

