/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolnight;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DiggerZombieEntity
extends PVZZombieEntity
implements IHasMetal {
    private static final DataParameter<Boolean> HAS_PICKAXE = EntityDataManager.func_187226_a(DiggerZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int MAX_ANIM_TIME = 30;

    public DiggerZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setPickaxe(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_PICKAXE, (Object)true);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target = this.func_70638_az();
            if (this.hasPickaxe()) {
                if (target != null) {
                    if (this.func_70068_e((Entity)target) <= 8.0) {
                        this.setAttackTime(MathHelper.func_76125_a((int)(this.getAttackTime() + 1), (int)0, (int)30));
                    } else {
                        this.setAttackTime(MathHelper.func_76125_a((int)(this.getAttackTime() - 1), (int)0, (int)30));
                    }
                } else {
                    this.setAttackTime(MathHelper.func_76125_a((int)(this.getAttackTime() - 1), (int)0, (int)30));
                }
            } else {
                this.setAttackTime(MathHelper.func_76125_a((int)(this.getAttackTime() + 1), (int)0, (int)30));
            }
            this.updateAttributes(this.hasPickaxe());
        }
        this.func_213323_x_();
    }

    private void updateAttributes(boolean has) {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(has ? 10.0 : 6.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(has ? (double)0.22f : (double)0.19f);
    }

    @Override
    public float getLife() {
        return 40.0f;
    }

    @Override
    public boolean hasMetal() {
        return this.hasPickaxe();
    }

    @Override
    public void decreaseMetal() {
        this.setPickaxe(false);
    }

    @Override
    public void increaseMetal() {
        this.setPickaxe(true);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.IRON_PICKAXE;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.4f, (float)((float)this.getAttackTime() * 0.02f + 0.1f));
        }
        return EntitySize.func_220314_b((float)0.8f, (float)((float)this.getAttackTime() * 0.06f + 0.2f));
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("digger_has_pickaxe")) {
            this.setPickaxe(compound.func_74767_n("digger_has_pickaxe"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("digger_has_pickaxe", this.hasPickaxe());
    }

    public void setPickaxe(boolean has) {
        this.field_70180_af.func_187227_b(HAS_PICKAXE, (Object)has);
    }

    public boolean hasPickaxe() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_PICKAXE);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.DIGGER_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.DIGGER_ZOMBIE;
    }
}

