/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolnight;

import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class PogoZombieEntity
extends PVZZombieEntity
implements IHasMetal {
    private static final DataParameter<Boolean> HAS_POGO = EntityDataManager.func_187226_a(PogoZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final int JUMP_CD = 30;

    public PogoZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setPogo(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_POGO, (Object)true);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K && this.hasPogo() && this.field_70173_aa % this.JUMP_CD == 0) {
            double motionY = 0.85;
            this.func_213293_j(this.func_213322_ci().func_82615_a(), motionY, this.func_213322_ci().func_82616_c());
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POGO.get());
        }
    }

    @Override
    public boolean checkCanZombieBreakBlock() {
        if (super.checkCanZombieBreakBlock()) {
            return !this.hasMetal();
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76355_l() == DamageSource.field_76379_h.field_76373_n) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean hasMetal() {
        return this.hasPogo();
    }

    @Override
    public void decreaseMetal() {
        this.setPogo(false);
    }

    @Override
    public void increaseMetal() {
        this.setPogo(true);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.POGO;
    }

    @Override
    public boolean canBeFrozen() {
        return !this.hasPogo();
    }

    @Override
    public boolean canBeButter() {
        return !this.hasPogo();
    }

    @Override
    public float getLife() {
        return 48.0f;
    }

    public boolean hasPogo() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_POGO);
    }

    public void setPogo(boolean has) {
        this.field_70180_af.func_187227_b(HAS_POGO, (Object)has);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_pogo")) {
            this.setPogo(compound.func_74767_n("has_pogo"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_pogo", this.hasPogo());
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.POGO_ZOMBIE;
    }
}

