/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.zombotany;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.entity.zombie.zombotany.AbstractZombotanyEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class PeaShooterZombieEntity
extends AbstractZombotanyEntity {
    private int shootTick = 0;

    public PeaShooterZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            ++this.shootTick;
            if (this.shootTick >= this.getFixedShootCD()) {
                this.setAttackTime(this.getShootNum());
                this.shootTick = 0;
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
                this.shootPea();
            }
        }
    }

    public float getAttackDamage() {
        return 3.0f;
    }

    private void shootPea() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        PeaEntity pea = new PeaEntity(this.field_70170_p, (LivingEntity)this, PeaEntity.Type.NORMAL, PeaEntity.State.NORMAL);
        pea.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
        pea.shootToTarget(target, 1.5);
        this.field_70170_p.func_217376_c((Entity)pea);
        EntityUtil.playSound((Entity)this, SoundEvents.field_187805_fE);
    }

    @Override
    public float getLife() {
        return 20.0f;
    }

    protected int getFixedShootCD() {
        int now = this.getShootCD();
        if (this.func_70644_a((Effect)EffectRegister.COLD_EFFECT.get())) {
            int lvl = this.func_70660_b((Effect)EffectRegister.COLD_EFFECT.get()).func_76458_c();
            now += 3 * lvl;
        }
        return now;
    }

    protected int getShootCD() {
        return 30;
    }

    protected int getShootNum() {
        return 1;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("shoot_tick")) {
            this.shootTick = compound.func_74762_e("shoot_tick");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("shoot_tick", this.shootTick);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.PEASHOOTER_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.PEASHOOTER_ZOMBIE;
    }
}

