/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.event;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.entity.plant.explosion.CobCannonEntity;
import com.hungteen.pvz.register.KeyBindRegister;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.RenderUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pvz", value={Dist.CLIENT})
public class OverlayEvents {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation RESOURCE = StringUtil.prefix("textures/gui/overlay/resource.png");
    private static final ResourceLocation FOG = StringUtil.prefix("textures/gui/overlay/fog.png");
    private static final ResourceLocation INVASION = StringUtil.prefix("textures/gui/overlay/invasion.png");
    private static final ResourceLocation TARGET = StringUtil.prefix("textures/gui/overlay/target.png");
    private static final int W = 160;
    private static final int H = 32;
    private static final int BAR_LEN = 123;
    private static final int BAR_H = 26;

    @SubscribeEvent
    public static void onPostRenderOverlay(RenderGameOverlayEvent.Post ev) {
        if (ev.getType() != RenderGameOverlayEvent.ElementType.ALL || OverlayEvents.mc.field_71439_g == null || OverlayEvents.mc.field_71474_y.field_74319_N || OverlayEvents.mc.field_71439_g.func_175149_v()) {
            return;
        }
        if (OverlayEvents.mc.field_71462_r == null) {
            CobCannonEntity cob;
            if (KeyBindRegister.showPlayerResources) {
                if (((Boolean)PVZConfig.CLIENT_CONFIG.ResourceRender.RenderSunNumBar.get()).booleanValue()) {
                    // empty if block
                }
                if (OverlayEvents.checkCurrentPos(KeyBindRegister.currentResourcePos)) {
                    if (KeyBindRegister.currentResourcePos == 0) {
                        OverlayEvents.drawSunNumBar(ev.getMatrixStack());
                    } else if (KeyBindRegister.currentResourcePos == 1) {
                        OverlayEvents.drawMoneyBar(ev.getMatrixStack());
                    } else if (KeyBindRegister.currentResourcePos == 2) {
                        OverlayEvents.drawGemBar(ev.getMatrixStack());
                    }
                }
                if (((Boolean)PVZConfig.CLIENT_CONFIG.ResourceRender.RenderEnergyNumBar.get()).booleanValue()) {
                    OverlayEvents.drawEnergyNumBar(ev.getMatrixStack(), ev.getWindow().func_198107_o(), ev.getWindow().func_198087_p());
                }
            }
            if (KeyBindRegister.showInvasionProgress && PlayerUtil.isPlayerSurvival((PlayerEntity)OverlayEvents.mc.field_71439_g) && ((Boolean)PVZConfig.CLIENT_CONFIG.InvasionRender.RenderInvasionProgress.get()).booleanValue()) {
                OverlayEvents.renderInvasionProgress(ev.getMatrixStack(), ev.getWindow().func_198107_o(), ev.getWindow().func_198087_p());
            }
            if (OverlayEvents.mc.field_71439_g.func_184187_bx() instanceof CobCannonEntity && (cob = (CobCannonEntity)OverlayEvents.mc.field_71439_g.func_184187_bx()).getCornNum() > 0) {
                OverlayEvents.renderTargetAim(ev.getMatrixStack(), ev.getWindow().func_198107_o(), ev.getWindow().func_198087_p());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderFog(RenderGameOverlayEvent.Pre ev) {
        int tick;
        if (ev.getType() != RenderGameOverlayEvent.ElementType.ALL || OverlayEvents.mc.field_71439_g == null || OverlayEvents.mc.field_71439_g.func_175149_v()) {
            return;
        }
        if (((Boolean)PVZConfig.CLIENT_CONFIG.EnvironmentRender.RenderFog.get()).booleanValue() && (tick = ClientPlayerResources.getPlayerStats(Resources.NO_FOG_TICK)) < 0) {
            OverlayEvents.renderFog(ev.getMatrixStack(), ev.getWindow().func_198107_o(), ev.getWindow().func_198087_p(), Math.min((float)(-tick) * 1.0f / 100.0f, 1.0f));
        }
    }

    private static void renderInvasionProgress(MatrixStack stack, int w, int h) {
        if (ClientPlayerResources.totalWaveCount == 0) {
            return;
        }
        stack.func_227860_a_();
        float scale = 0.5f;
        int offsetY = 0;
        int offsetX = 0;
        stack.func_227862_a_(scale, scale, scale);
        mc.func_110434_K().func_110577_a(INVASION);
        int WIDTH = 157;
        int HEIGHT = 21;
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, w * 2 - 157 + offsetX, h * 2 - 21 + offsetY, 0, 0, 157, 21);
        int P_WIDTH = 143;
        int P_HEIGHT = 7;
        int barlen = RenderUtil.getRenderBarLen((int)(OverlayEvents.mc.field_71439_g.field_70170_p.func_72820_D() % 24000L), 24000, 143);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, w * 2 - barlen - 7 + offsetX, h * 2 - 21 + 7 + offsetY, 149 - barlen + 1, 28, barlen, 7);
        for (int i = 0; i < ClientPlayerResources.totalWaveCount; ++i) {
            boolean rise = ClientPlayerResources.zombieWaveTime[i] >= 30000;
            int waveTime = rise ? ClientPlayerResources.zombieWaveTime[i] - 30000 : ClientPlayerResources.zombieWaveTime[i];
            int waveLen = RenderUtil.getRenderBarLen(waveTime, 24000, 143);
            OverlayEvents.mc.field_71456_v.func_238474_b_(stack, w * 2 - waveLen - 11 + offsetX, h * 2 - 21 + (rise ? -9 : -4) + offsetY, 27, 42, 20, rise ? 27 : 19);
        }
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, w * 2 - barlen - 11 + offsetX, h * 2 - 21 - 4 + offsetY, 0, 42, 24, 23);
        stack.func_227865_b_();
    }

    private static void renderTargetAim(MatrixStack stack, int w, int h) {
        stack.func_227860_a_();
        float scale = 1.0f;
        stack.func_227862_a_(scale, scale, scale);
        mc.func_110434_K().func_110577_a(TARGET);
        int WIDTH = 32;
        int HEIGHT = 32;
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, (w - 32) / 2 - 0, (h - 32) / 2 - 0, 0, 0, 32, 32);
        stack.func_227865_b_();
    }

    private static void renderFog(MatrixStack stack, int w, int h, float dep) {
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)dep);
        mc.func_110434_K().func_110577_a(FOG);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, (double)h, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)w, (double)h, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)w, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        stack.func_227865_b_();
    }

    private static void drawSunNumBar(MatrixStack stack) {
        int lvl = ClientPlayerResources.getPlayerStats(Resources.TREE_LVL);
        int maxNum = PlayerUtil.getPlayerMaxSunNum(lvl);
        int num = ClientPlayerResources.getPlayerStats(Resources.SUN_NUM);
        int len = RenderUtil.getRenderBarLen(num, maxNum, 123);
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227862_a_(0.6f, 0.6f, 0.6f);
        mc.func_110434_K().func_110577_a(RESOURCE);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, 0, 0, 0, 0, 160, 32);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, 0, 3, 0, 35, 34 + len, 26);
        StringUtil.drawCenteredScaledString(stack, OverlayEvents.mc.field_71466_p, num + "", 95, 5, 0xFFFFFF, 3.0f);
        stack.func_227865_b_();
    }

    private static void drawMoneyBar(MatrixStack stack) {
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227862_a_(0.6f, 0.6f, 0.6f);
        mc.func_110434_K().func_110577_a(RESOURCE);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, 0, 0, 0, 96, 160, 32);
        StringUtil.drawCenteredScaledString(stack, OverlayEvents.mc.field_71466_p, ClientPlayerResources.getPlayerStats(Resources.MONEY) + "", 95, 5, 0xFFFFFF, 3.0f);
        stack.func_227865_b_();
    }

    private static void drawGemBar(MatrixStack stack) {
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227862_a_(0.6f, 0.6f, 0.6f);
        mc.func_110434_K().func_110577_a(RESOURCE);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, 0, 0, 0, 128, 160, 32);
        StringUtil.drawCenteredScaledString(stack, OverlayEvents.mc.field_71466_p, ClientPlayerResources.getPlayerStats(Resources.GEM_NUM) + "", 95, 5, 0xFFFFFF, 3.0f);
        stack.func_227865_b_();
    }

    private static void drawEnergyNumBar(MatrixStack stack, int w, int h) {
        int maxNum = ClientPlayerResources.getPlayerStats(Resources.MAX_ENERGY_NUM);
        int num = ClientPlayerResources.getPlayerStats(Resources.ENERGY_NUM);
        stack.func_227860_a_();
        mc.func_110434_K().func_110577_a(RESOURCE);
        RenderSystem.enableBlend();
        stack.func_227862_a_(0.5f, 0.5f, 0.5f);
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, 0, 2 * h - 32, 0, 64, 35, 32);
        int currentX = 35;
        for (int i = 0; i < maxNum; ++i) {
            if (num > 0) {
                --num;
                OverlayEvents.mc.field_71456_v.func_238474_b_(stack, currentX, 2 * h - 32, 35, 64, 26, 32);
            } else {
                OverlayEvents.mc.field_71456_v.func_238474_b_(stack, currentX, 2 * h - 32, 61, 64, 26, 32);
            }
            currentX += 26;
        }
        OverlayEvents.mc.field_71456_v.func_238474_b_(stack, currentX, 2 * h - 32, 156, 64, 4, 32);
        stack.func_227865_b_();
    }

    public static boolean checkCurrentPos(int pos) {
        if (pos == 0) {
            return (Boolean)PVZConfig.CLIENT_CONFIG.ResourceRender.RenderSunNumBar.get();
        }
        if (pos == 1) {
            return (Boolean)PVZConfig.CLIENT_CONFIG.ResourceRender.RenderMoneyBar.get();
        }
        if (pos == 2) {
            return (Boolean)PVZConfig.CLIENT_CONFIG.ResourceRender.RenderGemBar.get();
        }
        System.out.println("Error : Wrong Resource Render Pos !");
        return false;
    }
}

