/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.event;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.capability.player.PlayerDataManager;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.event.events.PlayerLevelUpEvent;
import com.hungteen.pvz.event.events.SummonCardUseEvent;
import com.hungteen.pvz.event.handler.PlayerEventHandler;
import com.hungteen.pvz.gui.container.shop.MysteryShopContainer;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.item.tool.PeaGunItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.network.OtherStatsPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.EnchantmentRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.ItemUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pvz")
public class PVZPlayerEvents {
    @SubscribeEvent
    public static void tickPlayer(TickEvent.PlayerTickEvent ev) {
        if (!ev.player.field_70170_p.field_72995_K) {
            ItemStack stack = ev.player.func_184582_a(EquipmentSlotType.HEAD);
            if (stack.func_77973_b() instanceof PeaGunItem && !ev.player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                ((PeaGunItem)stack.func_77973_b()).checkAndShootPea(ev.player.field_70170_p, ev.player, stack);
                if (!ev.player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                    ev.player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 200);
                }
            }
            ev.player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                if (l.getPlayerData().getOtherStats().playSoundTick > 0) {
                    --l.getPlayerData().getOtherStats().playSoundTick;
                }
                if (l.getPlayerData().getOtherStats().updateGoodTick > 0) {
                    --l.getPlayerData().getOtherStats().updateGoodTick;
                } else {
                    MysteryShopContainer.genNextGoods(ev.player);
                }
                int lightLvl = 0;
                if (ev.player.func_70644_a((Effect)EffectRegister.LIGHT_EYE_EFFECT.get())) {
                    lightLvl = 1 + ev.player.func_70660_b((Effect)EffectRegister.LIGHT_EYE_EFFECT.get()).func_76458_c();
                }
                if (lightLvl != l.getPlayerData().getOtherStats().lightLevel) {
                    PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)ev.player), (Object)new OtherStatsPacket(2, 0, lightLvl));
                    l.getPlayerData().getOtherStats().lightLevel = lightLvl;
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        PlayerEntity player = ev.getPlayer();
        if (!player.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            PlayerEventHandler.onPlayerLogin(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent ev) {
        PlayerEntity player = ev.getPlayer();
        if (!player.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                PlayerDataManager plData = l.getPlayerData();
                PlayerDataManager.ItemCDStats itemCDStats = plData.getItemCDStats();
                for (Plants p : Plants.values()) {
                    itemCDStats.setPlantCardBar(p, player.func_184811_cZ().func_185143_a((Item)PlantUtil.getPlantSummonCard(p), 0.0f));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone ev) {
        PlayerEntity player = ev.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            PlayerUtil.clonePlayerData(ev.getOriginal(), player);
        }
    }

    @SubscribeEvent
    public static void onPlayerGetAdvancement(AdvancementEvent ev) {
        if (!ev.getPlayer().field_70170_p.field_72995_K && ev.getAdvancement().func_192067_g().equals((Object)StringUtil.prefix("adventure/root"))) {
            if (((Boolean)PVZConfig.COMMON_CONFIG.WorldSettings.GiveBeginnerReward.get()).booleanValue()) {
                ev.getPlayer().func_191521_c(new ItemStack((IItemProvider)ItemRegister.PEA_SHOOTER_CARD.get()));
                ev.getPlayer().func_191521_c(new ItemStack((IItemProvider)ItemRegister.SUN_FLOWER_CARD.get()));
                ev.getPlayer().func_191521_c(new ItemStack((IItemProvider)ItemRegister.WALL_NUT_CARD.get()));
                ev.getPlayer().func_191521_c(new ItemStack((IItemProvider)ItemRegister.POTATO_MINE_CARD.get()));
            }
            if (ModList.get().isLoaded("patchouli")) {
                Optional.ofNullable(ForgeRegistries.ITEMS.getValue(ItemUtil.GUIDE_BOOK)).ifPresent(item -> {
                    ItemStack book = new ItemStack((IItemProvider)item, 1);
                    book.func_196082_o().func_74778_a("patchouli:book", "pvz:pvz_guide");
                    ev.getPlayer().func_191521_c(book);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent ev) {
        PlayerEntity player = ev.getPlayer();
        BlockState state = ev.getState();
        BlockPos pos = ev.getPos();
        if (!(player.field_70170_p.field_72995_K || state.func_177230_c() != Blocks.field_150349_c && state.func_177230_c() != Blocks.field_196804_gh)) {
            Random rand = new Random();
            if (rand.nextInt((Integer)PVZConfig.COMMON_CONFIG.BlockSettings.BreakBlock.PeaDropChance.get()) == 0) {
                player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ItemRegister.PEA.get(), 1)));
            }
            if (rand.nextInt((Integer)PVZConfig.COMMON_CONFIG.BlockSettings.BreakBlock.CabbageDropChance.get()) == 0) {
                player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ItemRegister.CABBAGE_SEEDS.get(), 1)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific ev) {
        Entity entity;
        World world = ev.getWorld();
        PlayerEntity player = ev.getPlayer();
        if (!world.field_72995_K && ev.getHand() == Hand.MAIN_HAND && (entity = ev.getTarget()) instanceof PVZPlantEntity && entity.func_70089_S()) {
            PVZPlantEntity plant = (PVZPlantEntity)entity;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof SwordItem) {
                if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentRegister.ENERGY_TRANSFER.get()), (ItemStack)stack) > 0 && plant.canStartSuperMode()) {
                    player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                        PlayerDataManager.PlayerStats stats = l.getPlayerData().getPlayerStats();
                        if (stats.getPlayerStats(Resources.ENERGY_NUM) >= 1) {
                            stats.addPlayerStats(Resources.ENERGY_NUM, -1);
                            plant.startSuperMode(true);
                        }
                    });
                }
            } else if (stack.func_77973_b() instanceof ShovelItem) {
                PlayerEventHandler.onPlantShovelByPlayer(player, plant, stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTreeLevelUp(PlayerLevelUpEvent.TreeLevelUpEvent ev) {
        if (!ev.getPlayer().field_70170_p.field_72995_K) {
            PlayerUtil.playClientSound(ev.getPlayer(), 9);
            PlayerUtil.addPlayerStats(ev.getPlayer(), Resources.LOTTERY_CHANCE, 3);
        }
    }

    @SubscribeEvent
    public static void onPlayerPlantLevelUp(PlayerLevelUpEvent.PlantLevelUpEvent ev) {
        if (!ev.getPlayer().field_70170_p.field_72995_K) {
            PlayerUtil.addPlayerStats(ev.getPlayer(), Resources.TREE_XP, ev.getCurrentLevel() * 2);
        }
    }

    @SubscribeEvent
    public static void onSummonCardUse(SummonCardUseEvent ev) {
        PlayerEntity player = ev.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            SearchOption a = null;
            if (ev.getItemStack().func_77973_b() instanceof PlantCardItem) {
                Plants plant = ((PlantCardItem)ev.getItemStack().func_77973_b()).plantType;
                a = SearchOption.get(plant);
            }
            PlayerUtil.unLockAlmanac(player, a);
        }
    }
}

