/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.screen.shop;

import com.hungteen.pvz.capability.player.ClientPlayerResources;
import com.hungteen.pvz.gui.container.shop.AbstractDaveShopContainer;
import com.hungteen.pvz.gui.container.shop.MysteryShopContainer;
import com.hungteen.pvz.gui.screen.shop.AbstractDaveShopScreen;
import com.hungteen.pvz.gui.screen.shop.PennyShopScreen;
import com.hungteen.pvz.network.ClickButtonPacket;
import com.hungteen.pvz.network.PVZPacketHandler;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.TradeUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MysteryShopScreen
extends AbstractDaveShopScreen {
    MysteryShopContainer mystery;

    public MysteryShopScreen(AbstractDaveShopContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        if (screenContainer instanceof MysteryShopContainer) {
            this.mystery = (MysteryShopContainer)screenContainer;
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.buyButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 206, this.field_147009_r + 85, 18, 18, (ITextComponent)new TranslationTextComponent("gui.pvz.dave_shop.buy"), button -> {
            if (this.buyButton.field_230694_p_) {
                PVZPacketHandler.CHANNEL.sendToServer((Object)new ClickButtonPacket(this.getShopID(), this.selectedGood.type, this.selectedGood.ordinal()));
            }
        }));
    }

    @Override
    protected boolean canBuyNow() {
        return this.selectedGood != null && this.selectedTrade != null && ClientPlayerResources.getPlayerStats(Resources.GEM_NUM) >= this.selectedTrade.money && ((AbstractDaveShopContainer)this.field_147002_h).canClickBuyButton();
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        stack.func_227860_a_();
        this.field_230706_i_.func_110434_K().func_110577_a(PennyShopScreen.TEXTURE);
        MysteryShopScreen.func_238464_a_((MatrixStack)stack, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, ClientPlayerResources.getPlayerStats(Resources.GEM_NUM) + "", this.field_147003_i + 25 + 44, this.field_147009_r + 9, 0xFFFFFF, 1.4f);
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.mystery_shop.title").getString(), this.field_147003_i + 115 + 82, this.field_147009_r + 6, 0, 1.4f);
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.dave_shop.time_left").func_240702_b_(":" + ClientPlayerResources.updateGoodTick).getString(), this.field_147003_i + 115 + 130, this.field_147009_r + 20, 0, 0.8f);
        stack.func_227865_b_();
    }

    @Override
    protected void renderTrade(MatrixStack stack, AbstractDaveShopScreen.TradeType trade, int posX, int posY) {
        StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, trade.money + "", posX + 31, posY + 4, 255, 1.2f);
        int offsetX = posX + 81;
        int offsetY = posY + 1;
        this.field_230707_j_.func_175042_a(TradeUtil.getGoodItemStack(trade.good), offsetX, offsetY);
    }

    @Override
    protected void renderDetails(MatrixStack stack) {
        if (this.selectedGood.toString().startsWith("ENJOY_CARD")) {
            Plants plant = Plants.values()[this.selectedGood.type];
            StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, new TranslationTextComponent("item.pvz." + plant.toString().toLowerCase() + "_enjoy_card").getString(), this.field_147003_i + 117 + 80, this.field_147009_r + 28 + 20, 0, 1.5f);
        } else {
            StringUtil.drawCenteredScaledString(stack, this.field_230712_o_, new TranslationTextComponent("gui.pvz.dave_shop." + this.selectedGood.toString().toLowerCase()).getString(), this.field_147003_i + 117 + 80, this.field_147009_r + 28 + 20, 0, 1.5f);
        }
    }

    @Override
    public List<TradeUtil.DaveGoods> getAvailableGoods() {
        ArrayList<TradeUtil.DaveGoods> list = new ArrayList<TradeUtil.DaveGoods>();
        for (int i = 0; i < 8; ++i) {
            if (ClientPlayerResources.mysteryGoods[i] == -1) continue;
            TradeUtil.DaveGoods good = TradeUtil.DaveGoods.valueOf(TradeUtil.DaveGoods.class, "ENJOY_CARD_" + i);
            list.add(good.setType(ClientPlayerResources.mysteryGoods[i]));
        }
        return list;
    }

    @Override
    protected List<ITextComponent> getToolTips(AbstractDaveShopScreen.TradeType type) {
        TradeUtil.DaveGoods good = type.good;
        int num = 1;
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        for (int i = 1; i <= num; ++i) {
            TranslationTextComponent text = new TranslationTextComponent("gui.pvz.dave_shop." + good.toString().toLowerCase() + i);
            if (good.toString().startsWith("ENJOY_CARD")) {
                text = new TranslationTextComponent("gui.pvz.dave_shop.enjoy_card");
            }
            list.add((ITextComponent)text);
        }
        return list;
    }

    @Override
    protected List<AbstractDaveShopScreen.TradeType> getTradeTypes() {
        ArrayList<AbstractDaveShopScreen.TradeType> list = new ArrayList<AbstractDaveShopScreen.TradeType>();
        this.getAvailableGoods().forEach(good -> list.add(new AbstractDaveShopScreen.TradeType(TradeUtil.getGoodCost(good), (TradeUtil.DaveGoods)((Object)good))));
        return list;
    }

    @Override
    protected ResourceLocation getTexture() {
        return PennyShopScreen.TEXTURE;
    }

    @Override
    protected int getShopID() {
        return 7;
    }
}

