/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.search;

import com.google.common.collect.Lists;
import com.hungteen.pvz.gui.screen.AbstractOptionScreen;
import com.hungteen.pvz.gui.search.OptionSearchGui;
import com.hungteen.pvz.gui.search.OptionWidget;
import com.hungteen.pvz.gui.search.SearchCategories;
import com.hungteen.pvz.gui.search.SearchOption;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OptionPage {
    private static final int MAX_NUM_PER_PAGE = 25;
    private static final int NUM_PER_ROW = 5;
    private final int xOffset = 10;
    private final int yOffset = 30;
    private final int size = 25;
    private final List<OptionWidget> buttons = Lists.newArrayListWithCapacity((int)25);
    private OptionWidget hoveredButton;
    private List<SearchOption> optionList;
    private Minecraft mc;
    private ToggleWidget forwardButton;
    private ToggleWidget backButton;
    private int totalPages;
    private int currentPage;
    private SearchOption lastClickedButton;

    public OptionPage(AbstractOptionScreen<?> screen) {
        for (int i = 0; i < 25; ++i) {
            this.buttons.add(new OptionWidget(screen));
        }
    }

    public void init(Minecraft minecraft, int x, int y) {
        this.mc = minecraft;
        for (int i = 0; i < this.buttons.size(); ++i) {
            int xx = x + this.xOffset + this.size * (i % 5);
            int yy = y + this.yOffset + this.size * (i / 5);
            this.buttons.get(i).setPosition(xx, yy);
        }
        int width = 150;
        int height = 170;
        int dis = 90;
        int side = (width - dis) / 2;
        this.forwardButton = new ToggleWidget(x + width / 2 + side, y + height, 12, 17, false);
        this.forwardButton.func_191751_a(1, 208, 13, 18, OptionSearchGui.TEXTURE);
        this.backButton = new ToggleWidget(x + width / 2 - side - 13, y + height, 12, 17, true);
        this.backButton.func_191751_a(1, 208, 13, 18, OptionSearchGui.TEXTURE);
        this.forwardButton.field_230694_p_ = true;
        this.backButton.field_230694_p_ = true;
    }

    public void render(MatrixStack stack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.totalPages > 1) {
            String s = this.currentPage + 1 + "/" + this.totalPages;
            StringUtil.drawCenteredScaledString(stack, this.mc.field_71466_p, s, x + 75, y + 175, 0xFFFFFF, 1.5f);
        }
        this.hoveredButton = null;
        for (OptionWidget card : this.buttons) {
            card.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            if (!card.field_230694_p_ || !card.func_230449_g_()) continue;
            this.hoveredButton = card;
        }
        this.backButton.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.forwardButton.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double p_198955_1_, double p_198955_3_, int p_198955_5_) {
        if (this.forwardButton.func_231044_a_(p_198955_1_, p_198955_3_, p_198955_5_)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.func_231044_a_(p_198955_1_, p_198955_3_, p_198955_5_)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (OptionWidget card : this.buttons) {
            if (!card.func_231044_a_(p_198955_1_, p_198955_3_, p_198955_5_)) continue;
            this.lastClickedButton = card.getSearchOption();
            return true;
        }
        return false;
    }

    public void renderTooltip(MatrixStack stack, int mouseX, int mouseY) {
        if (this.mc.field_71462_r != null && this.hoveredButton != null) {
            this.mc.field_71462_r.func_243308_b(stack, this.hoveredButton.getToolTipText(this.mc.field_71462_r), mouseX, mouseY);
        }
    }

    public void updateLists(List<SearchOption> list, boolean flag) {
        this.optionList = list;
        this.totalPages = (int)Math.ceil((double)list.size() / 25.0);
        if (this.totalPages <= this.currentPage || flag) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    private void updateButtonsForPage() {
        int i = 25 * this.currentPage;
        for (int j = 0; j < this.buttons.size(); ++j) {
            OptionWidget card = this.buttons.get(j);
            if (i + j < this.optionList.size()) {
                SearchOption a = this.optionList.get(i + j);
                card.init(a);
                card.field_230694_p_ = true;
                continue;
            }
            card.field_230694_p_ = false;
        }
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        this.forwardButton.field_230694_p_ = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.field_230694_p_ = this.totalPages > 1 && this.currentPage > 0;
    }

    public List<SearchOption> getCurrentList(SearchCategories category) {
        return SearchOption.getSearchOptionsByCategory(category);
    }

    public SearchOption getCurrentOption() {
        return this.lastClickedButton;
    }

    public void resetCurrentOption() {
        this.lastClickedButton = null;
    }
}

