/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.gui.search;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RecipeManager {
    private final List<RecipeIngredient> ingredients = Lists.newArrayList();
    private float time;

    public void render(Minecraft mc, MatrixStack stack, int left, int top, boolean p_194188_4_, float p_194188_5_) {
        stack.func_227860_a_();
        if (!Screen.func_231172_r_()) {
            this.time += p_194188_5_;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            RecipeIngredient ingredient = this.ingredients.get(i);
            int x = ingredient.getX() + left;
            int y = ingredient.getY() + top;
            AbstractGui.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x30FF0000);
            ItemStack itemstack = ingredient.getItem();
            ItemRenderer itemrenderer = mc.func_175599_af();
            itemrenderer.func_184391_a((LivingEntity)mc.field_71439_g, itemstack, x, y);
            RenderSystem.depthFunc((int)516);
            AbstractGui.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x30FFFFFF);
            RenderSystem.depthFunc((int)515);
            if (i != 0) continue;
            itemrenderer.func_175030_a(mc.field_71466_p, itemstack, x, y);
        }
        stack.func_227865_b_();
    }

    public void clear() {
        this.ingredients.clear();
        this.time = 0.0f;
    }

    public void setRecipe(List<Pair<Ingredient, Slot>> list) {
        list.forEach(pair -> this.addIngredient((Ingredient)pair.getFirst(), ((Slot)pair.getSecond()).field_75223_e, ((Slot)pair.getSecond()).field_75221_f));
    }

    public void addIngredient(Ingredient i, int x, int y) {
        this.ingredients.add(new RecipeIngredient(i, x, y));
    }

    public RecipeIngredient get(int pos) {
        return this.ingredients.get(pos);
    }

    public int size() {
        return this.ingredients.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RecipeIngredient {
        private final Ingredient ingredient;
        private final int x;
        private final int y;

        public RecipeIngredient(Ingredient p_i47604_2_, int x, int y) {
            this.ingredient = p_i47604_2_;
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public ItemStack getItem() {
            ItemStack[] aitemstack = this.ingredient.func_193365_a();
            return aitemstack[MathHelper.func_76141_d((float)(RecipeManager.this.time / 30.0f)) % aitemstack.length];
        }
    }
}

