/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.item.tool.card;

import com.hungteen.pvz.enchantment.EnchantmentUtil;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.GroupRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class SummonCardItem
extends Item {
    public final boolean isEnjoyCard;

    public SummonCardItem(boolean isEnjoyCard) {
        this(new Item.Properties().func_200916_a(GroupRegister.PVZ_CARD).func_200917_a(isEnjoyCard ? 16 : 1), isEnjoyCard);
    }

    public SummonCardItem(Item.Properties properties, boolean isEnjoyCard) {
        super(properties);
        this.isEnjoyCard = isEnjoyCard;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.isEnjoyCard) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public static int getItemStackSunCost(ItemStack stack) {
        if (stack.func_77973_b() instanceof ImitaterCardItem) {
            return ((ImitaterCardItem)stack.func_77973_b()).getImitateSunCost(stack);
        }
        if (stack.func_77973_b() instanceof PlantCardItem) {
            Plants plantType = ((PlantCardItem)stack.func_77973_b()).plantType;
            int cost = PlantUtil.getPlantSunCost(plantType);
            return Math.max(cost - EnchantmentUtil.getSunReduceNum(stack), 0);
        }
        return 0;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.sun_cost").func_240702_b_(":" + SummonCardItem.getItemStackSunCost(stack)).func_240699_a_(TextFormatting.YELLOW));
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && !this.isEnjoyCard;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 20;
    }

    public int func_77619_b() {
        return 20;
    }
}

