/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.model.entity.zombie;

import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public abstract class PVZZombieModel<T extends PVZZombieEntity>
extends EntityModel<T> {
    protected static final float HAND_MAX_ANGLE = AnimationUtil.byDegree(-120.0f);
    protected static final int MAX_ANIM_CD = 10;
    protected boolean isLeftHandFree = true;
    protected boolean isRightHandFree = true;
    protected boolean isHeadFree = true;

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.refreshAnim();
        this.updateFreeParts(entity);
        this.doWalkAnimation(limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        if (((PVZZombieEntity)entity).getAnimTime() > 0) {
            if (this.isLeftHandFree || this.isRightHandFree) {
                this.doHandEat(entity);
            }
        } else if (this.isZombieAngry(entity)) {
            this.doPreAttackPose();
        }
    }

    public void updateFreeParts(T entity) {
    }

    public void refreshAnim() {
    }

    protected void doWalkAnimation(float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        this.getZombieHead().field_78796_g = netHeadYaw / 57.295776f;
        this.getZombieHead().field_78795_f = headPitch / 57.295776f;
        this.getZombieLeftLeg().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.getZombieRightLeg().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (this.isRightHandFree) {
            this.getZombieRightHand().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (this.isLeftHandFree) {
            this.getZombieLeftHand().field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
    }

    protected void doPreAttackPose() {
        if (this.isLeftHandFree || this.isRightHandFree) {
            if (this.isLeftHandFree) {
                this.getZombieLeftHand().field_78795_f = HAND_MAX_ANGLE;
            }
            if (this.isRightHandFree) {
                this.getZombieRightHand().field_78795_f = HAND_MAX_ANGLE;
            }
        }
    }

    protected void doHandEat(T entity) {
        if (this.isLeftHandFree) {
            this.getZombieLeftHand().field_78795_f = HAND_MAX_ANGLE - AnimationUtil.getUpDown(10 - ((PVZZombieEntity)entity).getAnimTime(), 10, -70);
        }
        if (this.isRightHandFree) {
            this.getZombieRightHand().field_78795_f = HAND_MAX_ANGLE - AnimationUtil.getUpDown(10 - ((PVZZombieEntity)entity).getAnimTime(), 10, -70);
        }
    }

    protected boolean isZombieAngry(T entity) {
        return entity.func_213398_dR();
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.getZombieWholeBody().func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public abstract ModelRenderer getZombieLeftHand();

    public abstract ModelRenderer getZombieRightHand();

    public abstract ModelRenderer getZombieLeftLeg();

    public abstract ModelRenderer getZombieRightLeg();

    public abstract ModelRenderer getZombieHead();

    public abstract ModelRenderer getZombieUpBody();

    public abstract ModelRenderer getZombieWholeBody();
}

